<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Models/Ap.php';
require_once __DIR__ . '/../../app/Models/Vendor.php';
require_once __DIR__ . '/../../app/Config/functions.php';

class ApController {
    public function index(): void {
        require_login();
        $apModel = new Ap();
        $vendorModel = new Vendor();
        $bills = $apModel->getBills();
        $vendors = $vendorModel->getAll();
        include __DIR__ . '/../../app/Views/ap/index.php';
    }

    public function view(int $id): void {
        require_login();
        $apModel = new Ap();
        $bill = $apModel->getBill($id);
        $payments = $apModel->getPayments($id);
        include __DIR__ . '/../../app/Views/ap/view.php';
    }
}
