<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Models/Ar.php';
require_once __DIR__ . '/../../app/Models/Customer.php';
require_once __DIR__ . '/../../app/Config/functions.php';

class ArController {
    public function index(): void {
        require_login();

        $model = new Ar();
        $arList = $model->getAll();  // ✅ This defines $arList

        $custModel = new Customer();
        $customers = $custModel->getAll(); // used for modal dropdowns

        $title = "Accounts Receivable";
        include __DIR__ . '/../../app/Views/ar/index.php';
    }

    public function viewInvoice(int $id): void {
        require_login();
        $model = new Ar();
        $invoice = $model->getById($id);
        $items = $model->getItems($id);
        include __DIR__ . '/../../app/Views/ar/invoice-print.php';
    }
}
