<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../Controllers/ReportsController.php';
use FPDF\FPDF;

class ProfitLossPDF extends FPDF {
    function Header() {
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'Profit & Loss Statement',0,1,'C');
        $this->Ln(5);
    }
}

$controller = new ReportsController();
$res = $controller->profitLoss();

$pdf = new ProfitLossPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,10,'Income',0,1);
$pdf->SetFont('Arial','',10);

foreach($res['rows'] as $r){
    if($r['account_type']==='Income'){
        $pdf->Cell(120,8,$r['account_name'],0);
        $pdf->Cell(60,8,number_format($r['credit']-$r['debit'],2),0,1,'R');
    }
}

$pdf->Ln(5);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,10,'Expenses',0,1);
$pdf->SetFont('Arial','',10);
foreach($res['rows'] as $r){
    if($r['account_type']==='Expense'){
        $pdf->Cell(120,8,$r['account_name'],0);
        $pdf->Cell(60,8,number_format($r['debit']-$r['credit'],2),0,1,'R');
    }
}
$pdf->Ln(10);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(120,10,'Net Profit',0);
$pdf->Cell(60,10,'$'.number_format($res['net'],2),0,1,'R');

$pdf->Output('I','Profit_Loss_'.date('Ymd').'.pdf');
exit;
