<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Accounts Payable | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-file-invoice-dollar mr-2"></i> Accounts Payable</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#addBillModal">
      <i class="fas fa-plus"></i> Add Bill
    </button>
  </section>

  <section class="content mt-3">
    <div class="card">
      <div class="card-body table-responsive">
        <table class="table table-bordered table-striped">
          <thead class="bg-light">
            <tr>
              <th>Bill No</th><th>Vendor</th><th>Bill Date</th><th>Due Date</th>
              <th>Total (SGD)</th><th>Status</th><th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($bills as $b): ?>
              <tr>
                <td><?= htmlspecialchars($b['bill_no']) ?></td>
                <td><?= htmlspecialchars($b['vendor_name']) ?></td>
                <td><?= htmlspecialchars($b['bill_date']) ?></td>
                <td><?= htmlspecialchars($b['due_date']) ?></td>
                <td class="text-right"><?= number_format($b['total_amount'],2) ?></td>
                <td>
                  <span class="badge badge-<?= $b['status']=='paid'?'success':($b['status']=='partial'?'warning':'danger') ?>">
                    <?= ucfirst($b['status']) ?>
                  </span>
                </td>
                <td>
                  <a href="router.php?page=ap-view&id=<?= $b['id'] ?>" class="btn btn-sm btn-info"><i class="fas fa-eye"></i></a>
                  <button class="btn btn-sm btn-danger deleteBill" data-id="<?= $b['id'] ?>"><i class="fas fa-trash"></i></button>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<!-- Add Bill Modal -->
<?php include __DIR__ . '/bill-add.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$('.deleteBill').on('click',function(){
  if(confirm('Delete this bill?')){
    $.post('public/ajax/ap/bill-delete.php',{id:$(this).data('id')},()=>location.reload());
  }
});
</script>
</body>
</html>
