<!-- Payment Add Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1" aria-labelledby="addPaymentLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title"><i class="fas fa-credit-card mr-2"></i>Add Payment</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="addPaymentForm">
        <input type="hidden" name="bill_id" id="paymentBillId">
        <div class="modal-body">
          <div class="form-group">
            <label>Payment Date</label>
            <input type="date" name="payment_date" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Amount (SGD)</label>
            <input type="number" step="0.01" name="amount" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Method</label>
            <select name="method" class="form-control">
              <option>Cash</option>
              <option>Cheque</option>
              <option>Bank Transfer</option>
            </select>
          </div>
          <div class="form-group">
            <label>Reference No</label>
            <input type="text" name="reference_no" class="form-control">
          </div>
          <div class="form-group">
            <label>Remarks</label>
            <textarea name="remarks" rows="2" class="form-control"></textarea>
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success"><i class="fas fa-save mr-1"></i>Record Payment</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#addPaymentForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/ap/payment-add.php', $(this).serialize(), function(){
    $('#addPaymentModal').modal('hide');
    location.reload();
  });
});
</script>
