<?php require_once __DIR__ . '/../../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Accounts Receivable | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-file-invoice mr-2"></i>Accounts Receivable</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#addInvoiceModal"><i class="fas fa-plus"></i> New Invoice</button>
  </section>

  <section class="content mt-3">
    <div class="card">
      <div class="card-body">
        <table id="arTable" class="table table-bordered table-striped">
          <thead><tr><th>Invoice #</th><th>Customer</th><th>Date</th><th>Due</th><th>Total (SGD)</th><th>Status</th><th>Action</th></tr></thead>
          <tbody>
            <?php foreach($arList as $i): ?>
            <tr>
              <td><?= htmlspecialchars($i['invoice_no']) ?></td>
              <td><?= htmlspecialchars($i['customer_name']) ?></td>
              <td><?= htmlspecialchars($i['invoice_date']) ?></td>
              <td><?= htmlspecialchars($i['due_date']) ?></td>
              <td class="text-right"><?= number_format($i['total_amount'],2) ?></td>
              <td><span class="badge badge-<?= $i['status']=='paid'?'success':'warning' ?>"><?= ucfirst($i['status']) ?></span></td>
              <td>
                <a href="router.php?page=ar-view&id=<?= $i['id'] ?>" class="btn btn-sm btn-info"><i class="fas fa-print"></i></a>
                <button class="btn btn-sm btn-danger deleteInvoice" data-id="<?= $i['id'] ?>"><i class="fas fa-trash"></i></button>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-add.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
  $('#arTable').DataTable();
  $('#addInvoiceForm').on('submit',function(e){ e.preventDefault(); $.post('ajax/ar/add.php',$(this).serialize(),()=>location.reload()); });
  $('.deleteInvoice').click(function(){ if(confirm('Delete invoice?')) $.post('ajax/ar/delete.php',{id:$(this).data('id')},()=>location.reload()); });
});
</script>
</body>
</html>
