<?php
// Basic standalone printable invoice template
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<style>
body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
h1,h2,h3 { margin: 0; }
table { width: 100%; border-collapse: collapse; margin-top: 15px; }
th,td { border: 1px solid #ccc; padding: 6px; }
.text-right { text-align: right; }
.text-center { text-align: center; }
.header { text-align:center; margin-bottom:20px; }
</style>
</head>
<body>
<div class="header">
  <h2>SGAccount</h2>
  <h4>Tax Invoice</h4>
</div>

<table>
  <tr>
    <td>
      <strong>Invoice No:</strong> <?= htmlspecialchars($invoice['invoice_no']) ?><br>
      <strong>Date:</strong> <?= htmlspecialchars($invoice['invoice_date']) ?><br>
      <strong>Due Date:</strong> <?= htmlspecialchars($invoice['due_date']) ?><br>
    </td>
    <td>
      <strong>Bill To:</strong><br>
      <?= htmlspecialchars($invoice['customer_name']) ?><br>
      <?= htmlspecialchars($invoice['address']) ?><br>
      <?= htmlspecialchars($invoice['email']) ?><br>
      <?= htmlspecialchars($invoice['phone']) ?>
    </td>
  </tr>
</table>

<table>
  <thead>
    <tr>
      <th>Description</th>
      <th class="text-right">Amount (SGD)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><?= nl2br(htmlspecialchars($invoice['description'])) ?></td>
      <td class="text-right"><?= number_format($invoice['amount'],2) ?></td>
    </tr>
  </tbody>
  <tfoot>
    <tr><th>Total</th><th class="text-right"><?= number_format($invoice['amount'],2) ?></th></tr>
    <tr><th>Received</th><th class="text-right"><?= number_format($invoice['received_amount'],2) ?></th></tr>
    <tr><th>Balance Due</th><th class="text-right"><?= number_format($invoice['amount'] - $invoice['received_amount'],2) ?></th></tr>
  </tfoot>
</table>

<p class="text-center" style="margin-top:30px;">Thank you for your business!</p>
</body>
</html>
