<!-- Add Bank/Cash Account Modal -->
<div class="modal fade" id="addAccountModal" tabindex="-1" aria-labelledby="addAccountLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title"><i class="fas fa-plus-circle mr-2"></i>Add New Account</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="addAccountForm">
        <div class="modal-body">
          <div class="form-group">
            <label>Account Name</label>
            <input type="text" name="name" class="form-control" placeholder="e.g. DBS Current, Petty Cash" required>
          </div>
          <div class="form-group">
            <label>Bank Name</label>
            <input type="text" name="bank_name" class="form-control">
          </div>
          <div class="form-group">
            <label>Account No</label>
            <input type="text" name="account_no" class="form-control">
          </div>
          <div class="form-group">
            <label>Account Type</label>
            <select name="type" class="form-control">
              <option value="bank">Bank</option>
              <option value="cash">Cash</option>
            </select>
          </div>
          <div class="form-group">
            <label>Opening Balance (SGD)</label>
            <input type="number" step="0.01" name="balance" class="form-control" value="0.00">
          </div>
          <div class="form-group">
            <label>Remarks</label>
            <textarea name="remarks" class="form-control" rows="2"></textarea>
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary"><i class="fas fa-save mr-1"></i>Save</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#addAccountForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/bank/add-account.php', $(this).serialize(), function(r){
    alert(r.message);
    if(r.status==='success') location.reload();
  }, 'json');
});
</script>
