<!-- Add Transaction Modal -->
<div class="modal fade" id="addTransactionModal" tabindex="-1" aria-labelledby="addTransactionLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title"><i class="fas fa-credit-card mr-2"></i>Add Transaction</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="addTransactionForm">
        <div class="modal-body">
          <input type="hidden" name="account_id" value="<?= htmlspecialchars($_GET['id'] ?? 0) ?>">
          <div class="form-group">
            <label>Date</label>
            <input type="date" name="txn_date" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Description</label>
            <input type="text" name="description" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Type</label>
            <select name="type" class="form-control">
              <option value="deposit">Deposit</option>
              <option value="withdrawal">Withdrawal</option>
              <option value="transfer">Transfer</option>
            </select>
          </div>
          <div class="form-group">
            <label>Amount (SGD)</label>
            <input type="number" step="0.01" name="amount" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Reference No</label>
            <input type="text" name="reference_no" class="form-control">
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success"><i class="fas fa-save mr-1"></i>Save Transaction</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#addTransactionForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/bank/add-transaction.php', $(this).serialize(), function(r){
    alert(r.message);
    if(r.status==='success') location.reload();
  }, 'json');
});
</script>
