<div class="modal fade" id="addCoaModal" tabindex="-1" role="dialog" aria-labelledby="addCoaLabel">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <form id="addCoaForm">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title"><i class="fas fa-plus-circle mr-2"></i> Add New Account</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label>Account Code</label>
            <input type="text" name="account_code" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Account Name</label>
            <input type="text" name="account_name" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Account Type</label>
            <select name="account_type" class="form-control" required>
              <option>Asset</option>
              <option>Liability</option>
              <option>Equity</option>
              <option>Income</option>
              <option>Expense</option>
            </select>
          </div>
          <div class="form-group">
            <label>Description</label>
            <textarea name="description" class="form-control" rows="2"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#addCoaForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/coa/add.php', $(this).serialize(), function(resp){
    showToast(resp.message, resp.success ? 'success' : 'danger');
    if (resp.success) setTimeout(() => location.reload(), 1000);
  }, 'json');
});
</script>
