<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>GST Dashboard | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-percentage mr-2"></i> GST Dashboard</h1>
    <a href="router.php?page=gst-reports" class="btn btn-info"><i class="fas fa-table mr-1"></i> Detailed Report</a>
  </section>

  <section class="content mt-3">
    <div class="row">
      <div class="col-md-4">
        <div class="small-box bg-success">
          <div class="inner">
            <h3>$<?= number_format($summary['output_gst'], 2) ?></h3>
            <p>Output GST (Collected)</p>
          </div>
          <div class="icon"><i class="fas fa-arrow-up"></i></div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="small-box bg-danger">
          <div class="inner">
            <h3>$<?= number_format($summary['input_gst'], 2) ?></h3>
            <p>Input GST (Paid)</p>
          </div>
          <div class="icon"><i class="fas fa-arrow-down"></i></div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="small-box bg-primary">
          <div class="inner">
            <h3>$<?= number_format($summary['net_gst'], 2) ?></h3>
            <p>Net GST Payable/Claimable</p>
          </div>
          <div class="icon"><i class="fas fa-balance-scale"></i></div>
        </div>
      </div>
    </div>

    <h5 class="mt-4">📅 GST Filing History</h5>
    <table class="table table-bordered table-striped">
      <thead class="bg-light">
        <tr><th>Period</th><th>Output</th><th>Input</th><th>Net</th><th>Status</th></tr>
      </thead>
      <tbody>
        <?php foreach($history as $row): ?>
        <tr>
          <td><?= htmlspecialchars($row['period_start']) ?> → <?= htmlspecialchars($row['period_end']) ?></td>
          <td>$<?= number_format($row['output_gst'],2) ?></td>
          <td>$<?= number_format($row['input_gst'],2) ?></td>
          <td>$<?= number_format($row['net_gst'],2) ?></td>
          <td><span class="badge badge-<?= $row['status']==='filed'?'success':'secondary' ?>"><?= ucfirst($row['status']) ?></span></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <form method="post" action="public/ajax/gst/update-summary.php" class="mt-3">
      <input type="hidden" name="start" value="<?= htmlspecialchars($summary['period_start']) ?>">
      <input type="hidden" name="end" value="<?= htmlspecialchars($summary['period_end']) ?>">
      <input type="hidden" name="output" value="<?= $summary['output_gst'] ?>">
      <input type="hidden" name="input" value="<?= $summary['input_gst'] ?>">
      <button type="submit" class="btn btn-success"><i class="fas fa-save mr-1"></i>Save Summary</button>
      <a href="public/ajax/gst/export-csv.php?start=<?= $summary['period_start'] ?>&end=<?= $summary['period_end'] ?>" class="btn btn-outline-primary ml-2"><i class="fas fa-file-csv"></i> Export CSV</a>
      <a href="public/ajax/gst/export-xlsx.php?start=<?= $summary['period_start'] ?>&end=<?= $summary['period_end'] ?>" class="btn btn-outline-success ml-2"><i class="fas fa-file-excel"></i> Export Excel</a>
    </form>
  </section>
</div>

<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>
</body>
</html>
