<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/Config/functions.php';
require_once __DIR__ . '/../../../app/Config/database.php';
require_once __DIR__ . '/../../../app/Models/Company.php';
require_once __DIR__ . '/../../../app/Models/User.php';

// -------------------------------------------------------------
// Session Data
// -------------------------------------------------------------
$userId   = $_SESSION['user_id'] ?? null;
$userName = $_SESSION['user_name'] ?? 'Guest';
$userRole = ucfirst($_SESSION['role'] ?? 'Unknown');

// -------------------------------------------------------------
// Company Info
// -------------------------------------------------------------
try {
    $pdo = Database::getConnection();
    $companyModel = new Company($pdo);
    $company = $companyModel->getCompany();
} catch (Throwable $e) {
    $company = ['name' => 'SGAccount', 'logo_path' => null];
}

$companyName = htmlspecialchars($company['name'] ?? 'SGAccount');
$logo = '/assets/img/logo.png';

if (!empty($company['logo_path'])) {
    $uploadPath = '/uploads/' . ltrim($company['logo_path'], '/');
    $fullPath = $_SERVER['DOCUMENT_ROOT'] . $uploadPath;
    if (file_exists($fullPath)) {
        $logo = $uploadPath;
    }
}

/// ------------------------------------------------------------------
// 👤 Load user info
// ------------------------------------------------------------------
$userPhoto = 'assets/img/user.png';
if ($userId) {
    $userModel = new User();
    $user = $userModel->getById((int)$userId);
    if (!empty($user['profile_image'])) {
        $userPhoto = $user['profile_image'];
    }
}


// -------------------------------------------------------------
// Active Page
// -------------------------------------------------------------
$current = $_GET['page'] ?? 'dashboard';
?>

<!-- ============================================================= -->
<!-- MAIN SIDEBAR -->
<!-- ============================================================= -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">

  <!-- Brand Logo -->
  <a href="router.php?page=dashboard" class="brand-link text-center">
    <img src="<?= htmlspecialchars($logo) ?>" alt="Company Logo"
         class="brand-image img-circle elevation-3"
         style="opacity:.9; width:33px; height:33px;">
    <span class="brand-text font-weight-light"><?= $companyName ?></span>
  </a>

  <div class="sidebar">

    <!-- User Panel -->
    <div class="user-panel mt-3 pb-3 mb-3 d-flex align-items-center">
      <div class="image position-relative">
        <img src="<?= htmlspecialchars($userPhoto) ?>" alt="User Image"
             class="img-circle elevation-2"
             style="width:45px; height:45px; object-fit:cover;">
        <span class="badge badge-success position-absolute"
              style="bottom:-5px; right:-5px; font-size:0.6rem;">
          <?= htmlspecialchars($userRole) ?>
        </span>
      </div>
      <div class="info ml-2">
        <a href="#" class="d-block text-white font-weight-bold"><?= htmlspecialchars($userName) ?></a>
        <small class="text-muted"><?= htmlspecialchars($userRole) ?></small>
      </div>
    </div>

    <!-- Sidebar Search -->
    <div class="form-inline mt-2 mb-3">
      <div class="input-group" data-widget="sidebar-search">
        <input class="form-control form-control-sidebar" type="search"
               placeholder="Search menu..." aria-label="Search">
        <div class="input-group-append">
          <button class="btn btn-sidebar"><i class="fas fa-search fa-fw"></i></button>
        </div>
      </div>
    </div>

    <!-- Sidebar Menu -->
    <nav class="mt-2">
      <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">

        <!-- Dashboard -->
        <li class="nav-item">
          <a href="router.php?page=dashboard"
             class="nav-link <?= $current === 'dashboard' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-tachometer-alt"></i>
            <p>Dashboard <span class="right badge badge-info">Live</span></p>
          </a>
        </li>

        <!-- Accounting Modules -->
        <li class="nav-header">ACCOUNTING MODULES</li>
        <li class="nav-item">
          <a href="router.php?page=coa"
             class="nav-link <?= $current === 'coa' ? 'active' : '' ?>">
            <i class="fas fa-book nav-icon"></i><p>Chart of Accounts</p>
          </a>
        </li>
        <li class="nav-item">
          <a href="router.php?page=journal"
             class="nav-link <?= $current === 'journal' ? 'active' : '' ?>">
            <i class="fas fa-edit nav-icon"></i><p>General Journal</p>
          </a>
        </li>

        <!-- Receivables -->
        <li class="nav-item has-treeview <?= in_array($current, ['ar','customers']) ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= in_array($current, ['ar','customers']) ? 'active' : '' ?>">
            <i class="nav-icon fas fa-file-invoice-dollar"></i>
            <p>Accounts Receivable<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="router.php?page=ar" class="nav-link <?= $current === 'ar' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i><p>Invoices</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="router.php?page=customers" class="nav-link <?= $current === 'customers' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i><p>Customers</p>
              </a>
            </li>
          </ul>
        </li>

        <!-- Payables -->
        <li class="nav-item has-treeview <?= in_array($current, ['ap','vendors']) ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= in_array($current, ['ap','vendors']) ? 'active' : '' ?>">
            <i class="nav-icon fas fa-file-invoice"></i>
            <p>Accounts Payable<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="router.php?page=ap" class="nav-link <?= $current === 'ap' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i><p>Bills</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="router.php?page=vendors" class="nav-link <?= $current === 'vendors' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i><p>Vendors</p>
              </a>
            </li>
          </ul>
        </li>

        <!-- Bank & Cash -->
        <li class="nav-item">
          <a href="router.php?page=bank"
             class="nav-link <?= $current === 'bank' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-university"></i><p>Bank & Cash</p>
          </a>
        </li>

        <!-- GST -->
        <li class="nav-item has-treeview <?= in_array($current, ['gst','gst-reports']) ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= in_array($current, ['gst','gst-reports']) ? 'active' : '' ?>">
            <i class="nav-icon fas fa-percentage"></i>
            <p>GST (Tax)<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="router.php?page=gst" class="nav-link <?= $current === 'gst' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i><p>GST Summary</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="router.php?page=gst-reports" class="nav-link <?= $current === 'gst-reports' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i><p>GST Reports</p>
              </a>
            </li>
          </ul>
        </li>

        <!-- Reports -->
        <li class="nav-header">REPORTS</li>
        <li class="nav-item">
          <a href="router.php?page=trial-balance"
             class="nav-link <?= $current === 'trial-balance' ? 'active' : '' ?>">
            <i class="fas fa-balance-scale nav-icon"></i><p>Trial Balance</p>
          </a>
        </li>
        <li class="nav-item">
          <a href="router.php?page=profit-loss"
             class="nav-link <?= $current === 'profit-loss' ? 'active' : '' ?>">
            <i class="fas fa-chart-line nav-icon"></i><p>Profit &amp; Loss</p>
          </a>
        </li>
        <li class="nav-item">
          <a href="router.php?page=balance-sheet"
             class="nav-link <?= $current === 'balance-sheet' ? 'active' : '' ?>">
            <i class="fas fa-columns nav-icon"></i><p>Balance Sheet</p>
          </a>
        </li>
        <li class="nav-item">
          <a href="router.php?page=cashflow"
             class="nav-link <?= $current === 'cashflow' ? 'active' : '' ?>">
            <i class="fas fa-water nav-icon"></i><p>Cash Flow</p>
          </a>
        </li>

        <!-- Administration -->
        <?php if (($_SESSION['role'] ?? '') === 'admin'): ?>
        <li class="nav-header">ADMINISTRATION</li>
        <li class="nav-item">
          <a href="router.php?page=users"
             class="nav-link <?= $current === 'users' ? 'active' : '' ?>">
            <i class="fas fa-users-cog nav-icon"></i><p>User Management</p>
          </a>
        </li>
        <li class="nav-item">
          <a href="router.php?page=company"
             class="nav-link <?= $current === 'company' ? 'active' : '' ?>">
            <i class="fas fa-building nav-icon"></i><p>Company Settings</p>
          </a>
        </li>
        <?php endif; ?>

        <!-- System -->
        <li class="nav-header">SYSTEM</li>
        <li class="nav-item">
          <a href="router.php?page=settings"
             class="nav-link <?= $current === 'settings' ? 'active' : '' ?>">
            <i class="fas fa-cogs nav-icon"></i><p>System Settings</p>
          </a>
        </li>
        <li class="nav-item">
          <a href="router.php?page=logout" class="nav-link text-danger">
            <i class="fas fa-sign-out-alt nav-icon"></i><p>Logout</p>
          </a>
        </li>

      </ul>
    </nav>
  </div>
</aside>
