<?php
declare(strict_types=1);
require_once __DIR__ . '/../../Config/functions.php';
require_login();

$rows   = $data['rows'] ?? [];
$totals = $data['totals'] ?? [
    'assets' => 0, 'liabilities' => 0, 'equity' => 0,
    'balance_check' => 0, 'balanced' => true
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Balance Sheet | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<!-- Main Content -->
<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center mb-3">
    <h1><i class="fas fa-balance-scale mr-2"></i> Balance Sheet</h1>
    <button class="btn btn-secondary" data-toggle="modal" data-target="#filterModal">
      <i class="fas fa-filter"></i> Filter
    </button>
  </section>

  <section class="content">
    <div class="card shadow-sm">
      <div class="card-body">
        <?php
        // Group rows by type
        $grouped = ['Asset' => [], 'Liability' => [], 'Equity' => []];
        foreach ($rows as $r) {
            if (isset($grouped[$r['account_type']])) {
                $grouped[$r['account_type']][] = $r;
            }
        }
        ?>

        <!-- 🟢 Assets -->
        <h4 class="mt-2 text-success"><strong>Assets</strong></h4>
        <table class="table table-bordered mb-4 table-hover">
          <thead class="bg-light">
            <tr><th>Account</th><th class="text-right">Amount (SGD)</th></tr>
          </thead>
          <tbody>
          <?php foreach ($grouped['Asset'] as $r): ?>
            <?php $amt = (float)$r['total_debit'] - (float)$r['total_credit']; ?>
            <tr>
              <td><?= htmlspecialchars($r['account_name']) ?></td>
              <td class="text-right"><?= number_format($amt, 2) ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
          <tfoot class="bg-light font-weight-bold">
            <tr><td>Total Assets</td><td class="text-right"><?= number_format($totals['assets'], 2) ?></td></tr>
          </tfoot>
        </table>

        <!-- 🔴 Liabilities -->
        <h4 class="mt-3 text-danger"><strong>Liabilities</strong></h4>
        <table class="table table-bordered mb-4 table-hover">
          <thead class="bg-light">
            <tr><th>Account</th><th class="text-right">Amount (SGD)</th></tr>
          </thead>
          <tbody>
          <?php foreach ($grouped['Liability'] as $r): ?>
            <?php $amt = (float)$r['total_credit'] - (float)$r['total_debit']; ?>
            <tr>
              <td><?= htmlspecialchars($r['account_name']) ?></td>
              <td class="text-right"><?= number_format($amt, 2) ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
          <tfoot class="bg-light font-weight-bold">
            <tr><td>Total Liabilities</td><td class="text-right"><?= number_format($totals['liabilities'], 2) ?></td></tr>
          </tfoot>
        </table>

        <!-- 🔵 Equity -->
        <h4 class="mt-3 text-primary"><strong>Equity</strong></h4>
        <table class="table table-bordered table-hover">
          <thead class="bg-light">
            <tr><th>Account</th><th class="text-right">Amount (SGD)</th></tr>
          </thead>
          <tbody>
          <?php foreach ($grouped['Equity'] as $r): ?>
            <?php $amt = (float)$r['total_credit'] - (float)$r['total_debit']; ?>
            <tr>
              <td><?= htmlspecialchars($r['account_name']) ?></td>
              <td class="text-right"><?= number_format($amt, 2) ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
          <tfoot class="bg-light font-weight-bold">
            <tr><td>Total Equity</td><td class="text-right"><?= number_format($totals['equity'], 2) ?></td></tr>
          </tfoot>
        </table>

        <!-- ⚖️ Balance Check -->
        <?php
          $diff = (float)($totals['balance_check'] ?? 0);
          $isBalanced = abs($diff) < 0.01;
        ?>
        <div class="mt-4 p-3 bg-<?= $isBalanced ? 'success' : 'danger' ?> text-white rounded text-center shadow-sm">
          <h4>
            <?= $isBalanced ? 'Balanced' : 'Not Balanced' ?>
            (Diff: <?= number_format(abs($diff), 2) ?>)
          </h4>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-filter.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$('#filterForm').on('submit', function(e) {
  e.preventDefault();
  const s = $('input[name="start"]').val();
  const eDate = $('input[name="end"]').val();
  window.location = `router.php?page=balance-sheet&start=${s}&end=${eDate}`;
});
</script>

</body>
</html>
