<?php
declare(strict_types=1);
require_once __DIR__ . '/../../Config/functions.php';
require_login();

// Safe defaults
$rows  = $data['rows'] ?? [];
$inflow  = $data['total_inflow']  ?? 0.00;
$outflow = $data['total_outflow'] ?? 0.00;
$net     = $data['net_flow']      ?? 0.00;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Cash Flow Statement | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<!-- Content Wrapper -->
<div class="content-wrapper p-4">

  <section class="content-header d-flex justify-content-between align-items-center mb-3">
    <h1><i class="fas fa-water mr-2"></i> Cash Flow Statement</h1>
    <button class="btn btn-secondary" data-toggle="modal" data-target="#filterModal">
      <i class="fas fa-filter"></i> Filter
    </button>
  </section>

  <section class="content">
    <div class="row">
      <!-- Inflow -->
      <div class="col-md-4">
        <div class="small-box bg-success">
          <div class="inner">
            <h3>$<?= number_format($inflow, 2) ?></h3>
            <p>Total Cash Inflow</p>
          </div>
          <div class="icon"><i class="fas fa-arrow-circle-down"></i></div>
        </div>
      </div>

      <!-- Outflow -->
      <div class="col-md-4">
        <div class="small-box bg-danger">
          <div class="inner">
            <h3>$<?= number_format($outflow, 2) ?></h3>
            <p>Total Cash Outflow</p>
          </div>
          <div class="icon"><i class="fas fa-arrow-circle-up"></i></div>
        </div>
      </div>

      <!-- Net Flow -->
      <div class="col-md-4">
        <div class="small-box bg-<?= $net >= 0 ? 'primary' : 'warning' ?>">
          <div class="inner">
            <h3>$<?= number_format($net, 2) ?></h3>
            <p>Net Cash Flow</p>
          </div>
          <div class="icon"><i class="fas fa-equals"></i></div>
        </div>
      </div>
    </div>

    <div class="card shadow-sm">
      <div class="card-body">
        <h4 class="mb-3"><i class="fas fa-list-alt mr-2"></i> Cash Movements</h4>
        <table class="table table-bordered table-striped">
          <thead class="bg-light">
            <tr>
              <th>Date</th>
              <th>Account</th>
              <th class="text-right">Net Amount (SGD)</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!empty($rows)): ?>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= htmlspecialchars($r['journal_date']) ?></td>
                <td><?= htmlspecialchars($r['account_name']) ?></td>
                <td class="text-right">
                  <?= number_format((float)$r['net_amount'], 2) ?>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="3" class="text-center text-muted">No cash movements found for this period.</td></tr>
          <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-filter.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$('#filterForm').on('submit', function(e) {
  e.preventDefault();
  const s = $('input[name="start"]').val();
  const eDate = $('input[name="end"]').val();
  window.location = `router.php?page=cashflow&start=${s}&end=${eDate}`;
});
</script>

</body>
</html>
