<div class="modal fade" id="editSettingsModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <form id="editSettingsForm">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title"><i class="fas fa-edit"></i> Edit Settings</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label>Company Name</label>
            <input type="text" name="company_name" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Default Currency</label>
            <input type="text" name="default_currency" class="form-control" value="SGD" required>
          </div>
          <div class="form-group">
            <label>Financial Year Start</label>
            <input type="date" name="financial_year_start" class="form-control" required>
          </div>
          <div class="form-group">
            <label>GST Rate (%)</label>
            <input type="number" step="0.01" name="gst_rate" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Theme</label>
            <select name="theme" class="form-control">
              <option value="light">Light</option>
              <option value="dark">Dark</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save Changes</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#editSettingsForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/settings/update.php', $(this).serialize(), function(resp){
    alert(resp.message);
    if(resp.success) location.reload();
  }, 'json');
});
</script>
