<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Users | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <?php include __DIR__ . '/../layouts/header.php'; ?>
  <?php include __DIR__ . '/../layouts/sidebar.php'; ?>

  <div class="content-wrapper p-4">
    <section class="content-header d-flex justify-content-between align-items-center">
      <h1><i class="fas fa-users mr-2"></i>User Management</h1>
      <button class="btn btn-primary" data-toggle="modal" data-target="#addUserModal"><i class="fas fa-plus"></i> Add User</button>
    </section>

    <section class="content mt-3">
      <div class="card">
        <div class="card-body">
          <table id="userTable" class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>Photo</th><th>Name</th><th>Email</th><th>Role</th><th>Status</th><th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($users as $u): ?>
              <tr>
                <td>
                  <img src="<?= htmlspecialchars($u['profile_image'] ?? 'uploads/profile_photos/default.png') ?>" width="40" height="40" class="rounded-circle">
                </td>
                <td><?= htmlspecialchars($u['name']) ?></td>
                <td><?= htmlspecialchars($u['email']) ?></td>
                <td><span class="badge badge-info"><?= $u['role'] ?></span></td>
                <td><span class="badge badge-<?= $u['status']=='active'?'success':'secondary' ?>"><?= $u['status'] ?></span></td>
                <td>
                  <button class="btn btn-sm btn-warning editUser" data-id="<?= $u['id'] ?>"><i class="fas fa-edit"></i></button>
                  <button class="btn btn-sm btn-danger deleteUser" data-id="<?= $u['id'] ?>"><i class="fas fa-trash"></i></button>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </section>
  </div>

  <?php include __DIR__ . '/modal-add.php'; ?>
  <?php include __DIR__ . '/modal-edit.php'; ?>
  <?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net@1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
  $('#userTable').DataTable();

  // Add User
  $('#addUserForm').on('submit', function(e){
    e.preventDefault();
    var formData = new FormData(this);
    $.ajax({
      url: 'ajax/users/add.php', method: 'POST', data: formData,
      contentType: false, processData: false,
      success: function(resp){ location.reload(); }
    });
  });

  // Edit User
  $('.editUser').click(function(){
    let id = $(this).data('id');
    $.get('ajax/users/edit.php', {id:id}, function(html){
      $('#editUserModal .modal-body').html(html);
      $('#editUserModal').modal('show');
    });
  });

  // Delete User
  $('.deleteUser').click(function(){
    if(confirm('Delete this user?')){
      $.post('ajax/users/delete.php', {id:$(this).data('id')}, function(resp){ location.reload(); });
    }
  });
});
</script>
</body>
</html>
