<?php
declare(strict_types=1);
require_once __DIR__ . '/../../../app/Config/config.php';
require_once __DIR__ . '/../../../app/Models/Bank.php';
require_once __DIR__ . '/../../../app/Config/functions.php';

require_login();
header('Content-Type: application/json');

try {
    $id = (int)($_POST['id'] ?? 0);
    if ($id <= 0) throw new Exception('Invalid account ID.');

    $model = new Bank();
    $success = $model->deleteAccount($id);

    echo json_encode(['status' => $success ? 'success' : 'error', 'message' => $success ? 'Account deleted successfully.' : 'Failed to delete account.']);
} catch (Throwable $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
