<?php
declare(strict_types=1);
require_once __DIR__ . '/../../../app/Config/config.php';
require_once __DIR__ . '/../../../app/Models/Company.php';
require_once __DIR__ . '/../../../app/Config/functions.php';

require_login();
$model = new Company();

$logoPath = null;
if (!empty($_FILES['logo']['name'])) {
    $uploadDir = __DIR__ . '/../../uploads/';
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
    $filename = 'logo_' . time() . '.' . pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
    $target = $uploadDir . $filename;
    if (move_uploaded_file($_FILES['logo']['tmp_name'], $target)) {
        $logoPath = 'uploads/' . $filename;
    }
}

$data = [
    'name'       => $_POST['name'] ?? '',
    'address'    => $_POST['address'] ?? '',
    'phone'      => $_POST['phone'] ?? '',
    'email'      => $_POST['email'] ?? '',
    'gst_no'     => $_POST['gst_no'] ?? '',
    'logo_path'  => $logoPath ?: ($_POST['current_logo'] ?? null),
];

$model->update($data);
echo json_encode(['status'=>'success']);
