<?php
// Determine current report type dynamically
$reportType = basename($_SERVER['PHP_SELF'], '.php');
$titles = [
    'trial-balance'  => 'Trial Balance',
    'profit-loss'    => 'Profit & Loss Statement',
    'balance-sheet'  => 'Balance Sheet',
    'cashflow'       => 'Cash Flow Statement'
];
$reportTitle = $titles[$reportType] ?? 'Financial Report';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">
    <i class="fas fa-file-alt mr-2"></i><?= htmlspecialchars($reportTitle) ?>
  </h1>
  <div class="btn-group">
    <!-- Print -->
    <button type="button" class="btn btn-secondary" onclick="printReport()">
      <i class="fas fa-print"></i> Print
    </button>

    <!-- PDF Export -->
    <a href="router.php?page=pdf&type=<?= $reportType ?>" target="_blank" class="btn btn-danger" id="exportPdf">
      <i class="fas fa-file-pdf"></i> Export PDF
    </a>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function printReport() {
  window.print();
  Swal.fire({
    icon: 'success',
    title: 'Printing Started',
    text: 'Your report is now ready to print.',
    timer: 2000,
    showConfirmButton: false
  });
}

document.addEventListener('DOMContentLoaded', () => {
  const pdfBtn = document.getElementById('exportPdf');
  if (pdfBtn) {
    pdfBtn.addEventListener('click', () => {
      Swal.fire({
        icon: 'info',
        title: 'Generating PDF',
        text: 'Your PDF report will open in a new tab shortly...',
        timer: 2000,
        showConfirmButton: false
      });
    });
  }
});
</script>
