<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
body { font-family: DejaVu Sans, sans-serif; font-size:12px; }
h2,h3,h4 { margin:0; }
table { width:100%; border-collapse:collapse; margin-top:10px; }
th,td { border:1px solid #000; padding:5px; text-align:right; }
th:first-child,td:first-child { text-align:left; }
tfoot td { font-weight:bold; }
.page-break { page-break-after:always; }
</style>
</head>
<body>
<?php include __DIR__ . '/partials/header.php'; ?>

<!-- Report Table -->
<table>
<thead><tr><th>Account</th><th>Amount (SGD)</th></tr></thead>
<tbody>
<?php foreach($data['rows'] as $r): ?>
  <?php if($r['account_type'] === 'Income'): ?>
    <tr><td><?= htmlspecialchars($r['account_name']) ?></td><td><?= number_format($r['total_credit'] - $r['total_debit'],2) ?></td></tr>
  <?php endif; ?>
<?php endforeach; ?>
<tr><td><strong>Total Income</strong></td><td><strong><?= number_format($data['income_total'],2) ?></strong></td></tr>
</tbody>
</table>

<table>
<thead><tr><th>Expense Account</th><th>Amount (SGD)</th></tr></thead>
<tbody>
<?php foreach($data['rows'] as $r): ?>
  <?php if($r['account_type'] === 'Expense'): ?>
    <tr><td><?= htmlspecialchars($r['account_name']) ?></td><td><?= number_format($r['total_debit'] - $r['total_credit'],2) ?></td></tr>
  <?php endif; ?>
<?php endforeach; ?>
<tr><td><strong>Total Expenses</strong></td><td><strong><?= number_format($data['expense_total'],2) ?></strong></td></tr>
</tbody>
</table>

<div style="margin-top:20px;text-align:center;font-weight:bold;font-size:14px;">
<?= $data['net_profit'] >= 0 ? 'Net Profit' : 'Net Loss' ?>:
<?= number_format(abs($data['net_profit']),2) ?> SGD
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>
</body>
</html>
