<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../../config/database.php';

$db = Database::connect();

/*
|--------------------------------------------------------------------------
| Fetch Bookings with Relations
|--------------------------------------------------------------------------
*/
$stmt = $db->query("
    SELECT 
        b.*,
        s.service_name,
        c.name AS customer_name,
        c.email,
        d.name AS driver_name
    FROM bookings b
    JOIN services s ON s.id = b.service_id
    JOIN customers c ON c.id = b.customer_id
    LEFT JOIN drivers d ON d.id = b.driver_id
    ORDER BY b.created_at DESC
");

$bookings = $stmt->fetchAll();

/*
|--------------------------------------------------------------------------
| Status Badge Helper
|--------------------------------------------------------------------------
*/
function statusBadge($status)
{
    switch ($status) {

        case 'pending':
            return '<span class="badge badge-secondary">Pending</span>';

        case 'assigned':
            return '<span class="badge badge-primary">Assigned</span>';

        case 'accepted':
            return '<span class="badge badge-info">Accepted</span>';

        case 'on_the_way':
            return '<span class="badge badge-warning">On The Way</span>';

        case 'arrived':
            return '<span class="badge badge-dark">Arrived</span>';

        case 'started':
            return '<span class="badge badge-success">Started</span>';

        case 'completed':
            return '<span class="badge badge-success">Completed</span>';

        case 'cancelled':
            return '<span class="badge badge-danger">Cancelled</span>';

        default:
            return '<span class="badge badge-light">Unknown</span>';
    }
}
?>

<?php require_once __DIR__ . '/../includes/header.php'; ?>
<?php require_once __DIR__ . '/../includes/sidebar.php'; ?>

<div class="content-wrapper">

<section class="content-header">
<div class="container-fluid">
<div class="row mb-2">
<div class="col-sm-6">
<h1>Bookings Management</h1>
</div>
</div>
</div>
</section>

<section class="content">
<div class="container-fluid">

<div class="card">
<div class="card-header">
<h3 class="card-title">All Bookings</h3>
</div>

<div class="card-body table-responsive">

<table class="table table-bordered table-hover">
<thead class="thead-dark">
<tr>
<th>Reference</th>
<th>Customer</th>
<th>Service</th>
<th>Pickup Date</th>
<th>Vehicle</th>
<th>Driver</th>
<th>Price</th>
<th>Status</th>
<th width="120">Actions</th>
</tr>
</thead>

<tbody>

<?php foreach ($bookings as $booking): ?>

<tr>

<td>
<strong>
<?php echo htmlspecialchars($booking['booking_reference']); ?>
</strong>
</td>

<td>
<?php echo htmlspecialchars($booking['customer_name']); ?><br>
<small><?php echo htmlspecialchars($booking['email']); ?></small>
</td>

<td>
<?php echo htmlspecialchars($booking['service_name']); ?>
</td>

<td>
<?php echo date('d M Y H:i',
strtotime($booking['pickup_datetime'])); ?>
</td>

<td>
<?php echo ucfirst($booking['vehicle_type']); ?>
</td>

<td>
<?php echo $booking['driver_name']
? htmlspecialchars($booking['driver_name'])
: '<span class="text-muted">Unassigned</span>'; ?>
</td>

<td>
<strong>
$<?php echo number_format($booking['final_price'], 2); ?>
</strong>
</td>

<td>
<?php echo statusBadge($booking['status']); ?>
</td>

<td>

<a href="view.php?id=<?php echo $booking['id']; ?>"
class="btn btn-sm btn-info">
<i class="fas fa-eye"></i>
</a>

<a href="assign_driver.php?id=<?php echo $booking['id']; ?>"
class="btn btn-sm btn-warning">
<i class="fas fa-user-plus"></i>
</a>

</td>

</tr>

<?php endforeach; ?>

</tbody>
</table>

</div>
</div>

</div>
</section>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
