<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../../config/database.php';

$db = Database::connect();

$stmt = $db->query("
    SELECT 
        p.*,
        b.booking_reference,
        b.status AS booking_status,
        c.name AS customer_name,
        c.email
    FROM payments p
    JOIN bookings b ON b.id = p.booking_id
    JOIN customers c ON c.id = b.customer_id
    ORDER BY p.created_at DESC
");

$payments = $stmt->fetchAll();
?>

<?php require_once __DIR__ . '/../includes/header.php'; ?>
<?php require_once __DIR__ . '/../includes/sidebar.php'; ?>

<div class="content-wrapper">

<section class="content-header">
<div class="container-fluid">
<h1>Payment Approval Dashboard</h1>
</div>
</section>

<section class="content">
<div class="container-fluid">

<div class="card">
<div class="card-header">
<h3 class="card-title">All Payments</h3>
</div>

<div class="card-body table-responsive">

<table class="table table-bordered table-hover">
<thead class="thead-dark">
<tr>
<th>Booking</th>
<th>Customer</th>
<th>Method</th>
<th>Amount</th>
<th>Transaction Ref</th>
<th>Status</th>
<th>Created</th>
<th>Actions</th>
</tr>
</thead>

<tbody>

<?php foreach ($payments as $payment): ?>

<tr>

<td><?php echo $payment['booking_reference']; ?></td>

<td>
<?php echo htmlspecialchars($payment['customer_name']); ?><br>
<small><?php echo htmlspecialchars($payment['email']); ?></small>
</td>

<td><?php echo strtoupper($payment['payment_method']); ?></td>

<td>$<?php echo number_format($payment['paid_amount'],2); ?></td>

<td><?php echo htmlspecialchars($payment['transaction_reference']); ?></td>

<td>
<?php if ($payment['payment_status'] === 'pending'): ?>
<span class="badge badge-warning">Pending</span>
<?php elseif ($payment['payment_status'] === 'paid'): ?>
<span class="badge badge-success">Paid</span>
<?php else: ?>
<span class="badge badge-danger">Failed</span>
<?php endif; ?>
</td>

<td><?php echo date('d M Y H:i',
strtotime($payment['created_at'])); ?></td>

<td>

<?php if ($payment['payment_status'] === 'pending'): ?>

<a href="approve.php?id=<?php echo $payment['id']; ?>"
class="btn btn-sm btn-success">
Approve
</a>

<a href="reject.php?id=<?php echo $payment['id']; ?>"
class="btn btn-sm btn-danger">
Reject
</a>

<?php else: ?>

<span class="text-muted">—</span>

<?php endif; ?>

</td>

</tr>

<?php endforeach; ?>

</tbody>
</table>

</div>
</div>

</div>
</section>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
