<?php
require_once __DIR__ . '/vendor/autoload.php';

use App\Core\Database;

$db = Database::connect();

$ref = $_GET['ref'];

$stmt = $db->prepare("SELECT * FROM bookings WHERE booking_reference = ?");
$stmt->execute([$ref]);
$booking = $stmt->fetch();

if (!$booking) die('Invalid booking.');

$transaction_id = 'STRIPE_' . uniqid();

$db->beginTransaction();

$stmt = $db->prepare("
INSERT INTO payments
(booking_id, payment_method, payment_status, transaction_reference, paid_amount)
VALUES (?, 'stripe', 'paid', ?, ?)
");
$stmt->execute([
$booking['id'],
$transaction_id,
$booking['final_price']
]);

$stmt = $db->prepare("
UPDATE bookings SET status = 'completed'
WHERE id = ?
");
$stmt->execute([$booking['id']]);

$stmt = $db->prepare("
INSERT INTO booking_timeline
(booking_id, status, updated_by)
VALUES (?, 'paid via stripe', 'system')
");
$stmt->execute([$booking['id']]);

$db->commit();

header("Location: view_booking.php");
