<?php
require '../../app/db.php';
require '../includes/auth.php';

header('Content-Type: application/json');

$stmt = $pdo->query("
SELECT d.id, d.full_name, d.status, 
d.current_lat, d.current_lng,
b.booking_code, b.status AS job_status
FROM drivers d
LEFT JOIN bookings b 
ON d.id = b.driver_id 
AND b.status IN ('assigned','accepted','on_the_way','arrived')
WHERE d.current_lat IS NOT NULL
");

$drivers = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(['drivers' => $drivers]);
