<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Exclusive Concierge | Executive Control</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

<style>
body {
    font-family: 'Montserrat', sans-serif;
    background-color: #0B0F19;
    color: #E5E7EB;
}

/* ===== GLASS NAVBAR ===== */
.main-header {
    background: rgba(11,15,25,0.85);
    backdrop-filter: blur(12px);
    border-bottom: 1px solid rgba(201,162,77,0.25);
}

/* ===== GOLD SHIMMER BRAND ===== */
.brand-text {
    font-weight: 600;
    background: linear-gradient(90deg,#C9A24D,#f4e2a1,#C9A24D);
    background-size: 200% auto;
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    animation: shimmer 4s linear infinite;
}
@keyframes shimmer {
    0% { background-position: 0% center; }
    100% { background-position: 200% center; }
}

/* ===== GOLD HOVER EFFECT ===== */
.gold-glow {
    color: #C9A24D;
    transition: 0.3s;
}
.gold-glow:hover {
    text-shadow: 0 0 10px rgba(201,162,77,0.8);
}

/* ===== NOTIFICATION BADGE ===== */
.notification-badge {
    background: #C9A24D;
    color: #0B0F19;
    font-size: 10px;
    font-weight: 600;
}

/* ===== CLOCK ===== */
#liveClock {
    color: #9CA3AF;
    font-size: 13px;
}
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
<div class="wrapper">

<nav class="main-header navbar navbar-expand navbar-dark">

<ul class="navbar-nav">
<li class="nav-item">
<a class="nav-link gold-glow" data-widget="pushmenu" href="#">
<i class="fas fa-bars"></i>
</a>
</li>
</ul>

<ul class="navbar-nav ml-auto align-items-center">

<!-- LIVE CLOCK -->
<li class="nav-item mr-3 d-flex align-items-center">
<span id="liveClock"></span>
</li>

<!-- NOTIFICATION BELL -->
<li class="nav-item dropdown">
<a class="nav-link gold-glow"
data-toggle="dropdown"
href="#"
onclick="markNotificationsRead()">

<i class="far fa-bell"></i>
<span id="notificationCount"
class="badge notification-badge navbar-badge"
style="display:none;">0</span>
</a>

<div class="dropdown-menu dropdown-menu-right bg-dark border-secondary"
style="width:360px;max-height:400px;overflow:auto;"
id="notificationList">

<div class="dropdown-item text-center text-muted">
Loading notifications...
</div>

</div>
</li>

<!-- PROFILE -->
<li class="nav-item dropdown">
<a class="nav-link gold-glow" data-toggle="dropdown" href="#">
<i class="far fa-user-circle"></i>
<span class="ml-2"><?= $_SESSION['admin_name'] ?? '' ?></span>
</a>
<div class="dropdown-menu dropdown-menu-right bg-dark border-secondary">
<a href="#" class="dropdown-item text-light">
<i class="fas fa-user mr-2"></i> Profile
</a>
<div class="dropdown-divider border-secondary"></div>
<a href="logout.php" class="dropdown-item text-danger">
<i class="fas fa-sign-out-alt mr-2"></i> Logout
</a>
</div>
</li>

</ul>
</nav>

<script>

/* ===== LIVE CLOCK ===== */
function updateClock() {
    const now = new Date();
    document.getElementById('liveClock').innerText =
        now.toLocaleString();
}
setInterval(updateClock, 1000);
updateClock();

/* ===== SOUND ALERT SYSTEM ===== */
let lastNotificationId = 0;
const bookingSound = new Audio("assets/sounds/booking-alert.mp3");
bookingSound.volume = 0.6;

/* Unlock audio after first interaction */
document.addEventListener("click", function() {
    bookingSound.play().then(() => {
        bookingSound.pause();
        bookingSound.currentTime = 0;
    }).catch(()=>{});
}, { once: true });

/* ===== LOAD NOTIFICATIONS ===== */
function loadNotifications() {

fetch("api/get_notifications.php")
.then(res => res.json())
.then(data => {

    let list = document.getElementById("notificationList");
    let count = document.getElementById("notificationCount");

    if(data.unread > 0){
        count.style.display = "inline";
        count.innerText = data.unread;
    } else {
        count.style.display = "none";
    }

    list.innerHTML = "";

    if(data.notifications.length === 0){
        list.innerHTML = `
        <div class="dropdown-item text-muted text-center">
        No notifications
        </div>`;
        return;
    }

    data.notifications.forEach(n => {

        /* 🔊 PLAY SOUND ONLY FOR NEW BOOKING */
        if(n.type === 'booking' && n.id > lastNotificationId){
            bookingSound.play();
        }

        if(n.id > lastNotificationId){
            lastNotificationId = n.id;
        }

        let icon = "fa-info-circle";
        if(n.type === 'booking') icon = "fa-calendar-check";
        if(n.type === 'payment') icon = "fa-credit-card";
        if(n.type === 'driver') icon = "fa-id-badge";

        let redirect = "#";
        if(n.booking_id){
            redirect = "booking_view.php?id=" + n.booking_id;
        }

        list.innerHTML += `
        <a href="${redirect}"
           class="dropdown-item ${n.is_read==0 ? 'font-weight-bold':''}">
            <i class="fas ${icon} text-warning mr-2"></i>
            <strong>${n.title}</strong><br>
            <small>${n.message}</small><br>
            <small class="text-muted">${n.created_at}</small>
        </a>
        <div class="dropdown-divider border-secondary"></div>
        `;
    });

});
}

/* ===== MARK ALL READ ===== */
function markNotificationsRead(){
fetch("api/mark_notifications_read.php");
}

/* Poll every 5 seconds */
setInterval(loadNotifications, 5000);
loadNotifications();

</script>
