<?php
require_once '../app/db.php';
require 'includes/audit_helper.php';
logAudit('Authentication','Admin Login');


session_start();

if (isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM admins WHERE email=?");
    $stmt->execute([$email]);
    $admin = $stmt->fetch();

    if ($admin && password_verify($password, $admin['password'])) {

        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_name'] = $admin['name'];
        $_SESSION['admin_role'] = $admin['role'];

        header("Location: index.php");
        exit;
    } else {
        $error = "Invalid email or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Exclusive Concierge | Admin Login</title>

<link rel="stylesheet" 
href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">

<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

<style>
body {
    font-family: 'Montserrat', sans-serif;
    background: linear-gradient(
        rgba(11,15,25,0.95),
        rgba(11,15,25,0.95)
    ),
    url('../public/assets/images/hero.jpg') center/cover no-repeat;
    height: 100vh;
}

.login-wrapper {
    display: flex;
    height: 100vh;
}

.login-left {
    flex: 1;
    color: #C9A24D;
    display: flex;
    flex-direction: column;
    justify-content: center;
    padding: 80px;
}

.login-left h1 {
    font-weight: 600;
    font-size: 40px;
}

.login-left p {
    color: #9CA3AF;
    max-width: 400px;
}

.login-right {
    width: 420px;
    background: rgba(31,41,55,0.9);
    backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    padding: 40px;
}

.login-card {
    width: 100%;
}

.form-control {
    background: #0B0F19;
    border: 1px solid #1F2937;
    color: #E5E7EB;
}

.form-control:focus {
    border-color: #C9A24D;
    box-shadow: none;
}

.btn-gold {
    background: #C9A24D;
    color: #0B0F19;
    font-weight: 600;
}

.btn-gold:hover {
    background: #b88f3f;
    color: #0B0F19;
}

.login-title {
    color: #C9A24D;
    font-weight: 600;
    margin-bottom: 20px;
}

.footer-text {
    color: #6c757d;
    font-size: 12px;
    text-align: center;
    margin-top: 20px;
}
</style>

</head>
<body>

<div class="login-wrapper">

<div class="login-left d-none d-lg-flex">
    <h1>Exclusive Concierge</h1>
    <p>
        Executive Transport & Concierge Management Platform.
        Secure administrative access for authorized personnel only.
    </p>
</div>

<div class="login-right">
<div class="login-card">

<h4 class="login-title">Admin Login</h4>

<?php if($error): ?>
<div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<form method="POST">

<div class="form-group">
<label>Email</label>
<input type="email" name="email"
class="form-control"
required>
</div>

<div class="form-group">
<label>Password</label>
<input type="password" name="password"
class="form-control"
required>
</div>

<div class="form-group form-check">
<input type="checkbox" class="form-check-input" id="remember">
<label class="form-check-label text-muted" for="remember">
Remember Me
</label>
</div>

<button type="submit" class="btn btn-gold btn-block">
Secure Login
</button>

</form>

<div class="footer-text">
© <?= date('Y') ?> Exclusive Concierge
</div>

</div>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/jquery/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

</body>
</html>
