<?php

class PermissionService
{
    public static function hasPermission(int $adminId, string $permission): bool
    {
        global $pdo;

        $stmt = $pdo->prepare("
            SELECT COUNT(*)
            FROM admins a
            JOIN roles r ON a.role_id = r.id
            JOIN role_permissions rp ON r.id = rp.role_id
            JOIN permissions p ON rp.permission_id = p.id
            WHERE a.id = ?
            AND p.name = ?
        ");

        $stmt->execute([$adminId, $permission]);

        return (int)$stmt->fetchColumn() > 0;
    }
}
