<?php
session_start();
require_once __DIR__ . '/config/database.php';

$db = Database::connect();

/*
|--------------------------------------------------------------------------
| Fetch Services + Price Rules
|--------------------------------------------------------------------------
*/
$stmt = $db->query("
    SELECT 
        s.id,
        s.service_name,
        pr.pricing_type,
        pr.base_price,
        pr.hourly_rate,
        pr.minimum_hours,
        pr.zone_required,
        pr.airport_pickup_default,
        pr.airport_dropoff_default,
        pr.flight_required
    FROM services s
    JOIN price_rules pr ON pr.service_id = s.id
    WHERE pr.is_active = 1
    ORDER BY s.id ASC
");

$services = $stmt->fetchAll();

/*
|--------------------------------------------------------------------------
| Fetch Zones
|--------------------------------------------------------------------------
*/
$zones = $db->query("SELECT * FROM zones ORDER BY id ASC")->fetchAll();

/*
|--------------------------------------------------------------------------
| CSRF
|--------------------------------------------------------------------------
*/
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<?php require_once __DIR__ . '/includes/book_header.php'; ?>

<section class="section-padding">
<div class="container">

<div class="row justify-content-center">
<div class="col-lg-11">

<div class="booking-card p-5">

<form id="bookingForm">

<input type="hidden" name="csrf_token"
value="<?php echo $_SESSION['csrf_token']; ?>">

<div class="row">

<!-- ========================= -->
<!-- LEFT COLUMN -->
<!-- ========================= -->
<div class="col-lg-6 pr-lg-4">

<h5 class="gold-text mb-4">Service Details</h5>

<!-- SERVICE -->
<div class="form-group">
<label>Service Type</label>
<select class="form-control"
name="service_id"
id="service_id"
required>

<option value="">Select Service</option>

<?php foreach ($services as $service): ?>
<option value="<?php echo $service['id']; ?>"
data-pricing="<?php echo $service['pricing_type']; ?>"
data-base="<?php echo $service['base_price']; ?>"
data-hourly="<?php echo $service['hourly_rate']; ?>"
data-minhours="<?php echo $service['minimum_hours']; ?>"
data-zone="<?php echo $service['zone_required']; ?>"
data-airport-pickup="<?php echo $service['airport_pickup_default']; ?>"
data-airport-dropoff="<?php echo $service['airport_dropoff_default']; ?>"
data-flight="<?php echo $service['flight_required']; ?>">
<?php echo htmlspecialchars($service['service_name']); ?>
</option>
<?php endforeach; ?>

</select>
</div>

<!-- ZONE -->
<div class="form-group d-none" id="zoneGroup">
<label>Pickup Zone</label>
<select class="form-control" name="zone_id" id="zone_id">
<option value="">Select Zone</option>
<?php foreach ($zones as $zone): ?>
<option value="<?php echo $zone['id']; ?>"
data-price="<?php echo $zone['price_modifier']; ?>">
<?php echo htmlspecialchars($zone['zone_name']); ?>
($<?php echo number_format($zone['price_modifier'],2); ?>)
</option>
<?php endforeach; ?>
</select>
</div>

<!-- HOURS -->
<div class="form-group d-none" id="hourGroup">
<label>Number of Hours</label>
<input type="number"
class="form-control"
name="hours"
id="hours"
min="1"
value="1">
</div>

<!-- VEHICLE -->
<div class="form-group">
<label>Vehicle Type</label>
<select class="form-control"
name="vehicle_type"
id="vehicle_type"
required>
<option value="">Select Vehicle</option>
<option value="sedan">Sedan</option>
<option value="suv">SUV</option>
<option value="mpv">MPV</option>
<option value="limousine">Limousine</option>
</select>
</div>

<!-- PASSENGERS -->
<div class="form-row">
<div class="form-group col-md-6">
<label>Adults</label>
<input type="number"
class="form-control"
id="adult_count"
min="0"
value="1">
</div>
<div class="form-group col-md-6">
<label>Children</label>
<input type="number"
class="form-control"
id="child_count"
min="0"
value="0">
</div>
</div>

<!-- LUGGAGE -->
<div class="form-row">
<div class="form-group col-md-6">
<label>Large Luggage</label>
<input type="number"
class="form-control"
id="large_luggage"
min="0"
value="0">
</div>
<div class="form-group col-md-6">
<label>Small Luggage</label>
<input type="number"
class="form-control"
id="small_luggage"
min="0"
value="0">
</div>
</div>

<!-- CAPACITY ERROR -->
<div id="capacityError"
class="text-danger d-none mt-2"></div>

<!-- VEHICLE RECOMMENDATION -->
<div id="vehicleRecommendation"
class="vehicle-recommendation d-none mt-3"></div>

<!-- PICKUP -->
<div class="form-group mt-3">
<label>Pickup Address</label>
<input type="text"
class="form-control"
name="pickup_address"
required>
</div>

<!-- DROPOFF -->
<div class="form-group">
<label>Drop-off Address</label>
<input type="text"
class="form-control"
name="dropoff_address">
</div>

<!-- FLIGHT -->
<div class="form-group d-none" id="flightGroup">
<label>Flight Number</label>
<input type="text"
class="form-control"
name="flight_number"
placeholder="e.g. SQ322">
</div>

<!-- DATETIME -->
<div class="form-group">
<label>Pickup Date & Time</label>
<input type="datetime-local"
class="form-control"
name="pickup_datetime"
required>
</div>

</div>

<!-- ========================= -->
<!-- RIGHT COLUMN -->
<!-- ========================= -->
<div class="col-lg-6 pl-lg-4 booking-divider">

<h5 class="gold-text mb-4">Your Details</h5>

<div class="form-group">
<input type="text"
class="form-control"
name="name"
placeholder="Full Name"
required>
</div>

<div class="form-group">
<input type="email"
class="form-control"
name="email"
placeholder="Email Address"
required>
</div>

<div class="form-group">
<input type="text"
class="form-control"
name="phone"
placeholder="Phone Number">
</div>

<!-- ESTIMATED TOTAL -->
<div class="price-summary mt-5 p-4 text-center">
<h6 class="text-muted">Estimated Total</h6>
<h2 class="gold-text mb-0" id="totalPrice">$0.00</h2>
<small class="text-muted">
Final price will be confirmed after validation.
</small>
</div>

<button type="submit"
class="btn btn-gold btn-block mt-4">
Confirm Executive Booking
</button>

</div>
</div>
</form>
</div>
</div>
</div>
</div>
</section>

<script src="assets/js/booking.js"></script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
