<?php
session_start();
header('Content-Type: application/json');

require_once __DIR__ . '/config/database.php';

try {

if (
empty($_POST['csrf_token']) ||
$_POST['csrf_token'] !== $_SESSION['csrf_token']
) {
throw new Exception('Invalid token.');
}

$db = Database::connect();
$db->beginTransaction();

$ref = $_POST['booking_reference'];

$stmt = $db->prepare("
SELECT id, status
FROM bookings
WHERE booking_reference = ?
LIMIT 1
");
$stmt->execute([$ref]);
$booking = $stmt->fetch();

if (!$booking) {
throw new Exception('Booking not found.');
}

if ($booking['status'] !== 'pending') {
throw new Exception('Booking can no longer be modified.');
}

$stmt = $db->prepare("
UPDATE bookings
SET pickup_address = ?,
dropoff_address = ?,
pickup_datetime = ?,
flight_number = ?
WHERE id = ?
");

$stmt->execute([
$_POST['pickup_address'],
$_POST['dropoff_address'],
$_POST['pickup_datetime'],
$_POST['flight_number'] ?? null,
$booking['id']
]);

$stmt = $db->prepare("
INSERT INTO booking_timeline
(booking_id, status, updated_by)
VALUES (?, 'updated', 'customer')
");

$stmt->execute([$booking['id']]);

$db->commit();

echo json_encode([
'status' => 'success',
'ref' => $ref
]);

} catch (Exception $e) {

if (isset($db) && $db->inTransaction()) {
$db->rollBack();
}

echo json_encode([
'status' => 'error',
'message' => $e->getMessage()
]);
}
