<?php
declare(strict_types=1);
require_once __DIR__ . '/../../includes/config.php';

header('Content-Type: application/json; charset=utf-8');

function json_out($data, int $code=200): void {
  http_response_code($code);
  echo json_encode($data, JSON_UNESCAPED_SLASHES);
  exit;
}

function bearer_token(): ?string {
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
  if (preg_match('/Bearer\s+(.+)/i', $h, $m)) return trim($m[1]);
  return null;
}

function api_auth_user(): array {
  $token = bearer_token();
  if (!$token) json_out(['ok'=>false,'error'=>'Missing token'], 401);

  $hash = hash('sha256', $token);
  $stmt = db()->prepare("
    SELECT t.user_id, u.full_name, u.email
    FROM api_tokens t
    JOIN users u ON u.id=t.user_id
    WHERE t.token_hash=? AND t.expires_at > NOW()
    LIMIT 1
  ");
  $stmt->execute([$hash]);
  $row = $stmt->fetch();
  if (!$row) json_out(['ok'=>false,'error'=>'Invalid/expired token'], 401);

  db()->prepare("UPDATE api_tokens SET last_used_at=NOW() WHERE token_hash=?")->execute([$hash]);
  return $row;
}