<?php
declare(strict_types=1);
require_once __DIR__ . '/includes/auth.php';

// If logged in, route user into system (adjust if you prefer role-based)
if (is_logged_in()) {
    header('Location: login.php');
    exit;
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SecureHRMS | Command Operations Platform</title>

  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
  <link rel="manifest" href="manifest.json">
  <meta name="theme-color" content="#0B0F19">

  <style>
    :root{
      --bg0:#06080f;
      --bg1:#0b1020;
      --bg2:#101a2b;
      --hud:#00e5ff;
      --hud2:#2aff7a;
      --gold:#C9A24D;
      --muted:rgba(255,255,255,.75);
      --glass:rgba(255,255,255,.06);
      --glass2:rgba(255,255,255,.10);
      --line:rgba(255,255,255,.09);
      --shadow:0 24px 70px rgba(0,0,0,.65);
    }

    html,body{height:100%}
    body{
      margin:0;
      color:#fff;
      font-family: "Segoe UI", system-ui, -apple-system, Arial, sans-serif;
      background: radial-gradient(1200px 700px at 20% 10%, rgba(0,229,255,.10), transparent 55%),
                  radial-gradient(900px 600px at 80% 30%, rgba(42,255,122,.08), transparent 55%),
                  radial-gradient(1000px 700px at 50% 90%, rgba(201,162,77,.08), transparent 60%),
                  linear-gradient(135deg, var(--bg0), var(--bg1) 55%, var(--bg2));
      overflow-x:hidden;
    }

    /* ====== Animated background layers ====== */
    .layer{position:fixed; inset:0; pointer-events:none; z-index:0}

    /* Parallax grid */
    .grid{
      background-image:
        linear-gradient(rgba(255,255,255,.06) 1px, transparent 1px),
        linear-gradient(90deg, rgba(255,255,255,.06) 1px, transparent 1px);
      background-size: 60px 60px;
      opacity:.35;
      transform: translate3d(0,0,0);
    }

    /* Scanlines */
    .scanlines{
      background: repeating-linear-gradient(
        to bottom,
        rgba(255,255,255,.035),
        rgba(255,255,255,.035) 1px,
        transparent 3px,
        transparent 6px
      );
      opacity:.18;
      mix-blend-mode: overlay;
    }

    /* HUD sweep */
    .sweep:before{
      content:"";
      position:absolute; inset:-20%;
      background: conic-gradient(from 0deg,
        rgba(0,229,255,0) 0deg,
        rgba(0,229,255,.20) 25deg,
        rgba(0,229,255,0) 55deg,
        rgba(0,229,255,0) 360deg
      );
      animation: radar 6.5s linear infinite;
      filter: blur(0.2px);
      opacity:.45;
      transform-origin:center;
      mask-image: radial-gradient(circle at center, rgba(0,0,0,1) 0 38%, rgba(0,0,0,0) 64%);
      -webkit-mask-image: radial-gradient(circle at center, rgba(0,0,0,1) 0 38%, rgba(0,0,0,0) 64%);
    }
    @keyframes radar { to { transform: rotate(360deg); } }

    /* Floating beacons */
    .beacon{
      position:absolute;
      width:6px; height:6px;
      border-radius:50%;
      background: var(--hud2);
      box-shadow: 0 0 18px rgba(42,255,122,.75);
      opacity:.75;
      animation: rise linear infinite;
    }
    @keyframes rise{
      0%{ transform: translateY(0); opacity:0; }
      15%{ opacity:.85; }
      100%{ transform: translateY(-120vh); opacity:0; }
    }

    /* ====== Layout ====== */
    .wrap{
      position:relative;
      z-index:2;
      min-height:100vh;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:40px 18px 80px;
    }

    .frame{
      width: min(980px, 100%);
      border: 1px solid var(--line);
      border-radius: 20px;
      background: linear-gradient(180deg, rgba(255,255,255,.07), rgba(255,255,255,.04));
      backdrop-filter: blur(16px);
      box-shadow: var(--shadow);
      overflow:hidden;
      position:relative;
    }

    /* corner brackets */
    .frame:before, .frame:after{
      content:"";
      position:absolute;
      width:120px; height:120px;
      border:2px solid rgba(0,229,255,.30);
      opacity:.65;
      pointer-events:none;
    }
    .frame:before{ left:14px; top:14px; border-right:none; border-bottom:none; border-radius:16px 0 0 0; }
    .frame:after{ right:14px; bottom:14px; border-left:none; border-top:none; border-radius:0 0 16px 0; }

    .topbar{
      display:flex;
      align-items:center;
      justify-content:space-between;
      padding:16px 18px;
      border-bottom:1px solid var(--line);
      background: rgba(0,0,0,.20);
    }

    .brand{
      display:flex; align-items:center; gap:12px;
      letter-spacing:.6px;
    }
    .brand img{ width:44px; height:44px; object-fit:contain; }
    .brand .name{
      font-weight:800;
      font-size:18px;
      text-transform:uppercase;
    }
    .brand .tag{
      font-size:12px;
      color: rgba(255,255,255,.7);
      margin-top:-2px;
    }

    .status-pills{
      display:flex; gap:10px; flex-wrap:wrap; justify-content:flex-end;
    }
    .pill{
      font-size:12px;
      padding:6px 10px;
      border-radius:999px;
      border:1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.05);
      color: rgba(255,255,255,.85);
      display:flex; gap:8px; align-items:center;
      white-space:nowrap;
    }
    .dot{
      width:8px; height:8px; border-radius:50%;
      background: var(--hud2);
      box-shadow: 0 0 10px rgba(42,255,122,.75);
    }
    .dot.hud{ background: var(--hud); box-shadow: 0 0 10px rgba(0,229,255,.75); }
    .dot.gold{ background: var(--gold); box-shadow: 0 0 10px rgba(201,162,77,.6); }

    .content{
      padding:28px 22px 26px;
      display:grid;
      grid-template-columns: 1.1fr .9fr;
      gap:22px;
    }

    @media (max-width: 900px){
      .content{ grid-template-columns: 1fr; }
      .status-pills{ justify-content:flex-start; }
    }

    .hero h1{
      margin:0;
      font-weight:900;
      letter-spacing:1.2px;
      text-transform:uppercase;
      font-size:44px;
      line-height:1.05;
    }
    .hero h1 span{
      color: var(--hud);
      text-shadow: 0 0 20px rgba(0,229,255,.25);
    }

    .hero p{
      margin:14px 0 0;
      color: var(--muted);
      font-size:16px;
      line-height:1.6;
      max-width: 52ch;
    }

    .cta{
      margin-top:18px;
      display:flex;
      gap:12px;
      flex-wrap:wrap;
      align-items:center;
    }

    .btn-cmd{
      border:none;
      padding:12px 18px;
      border-radius:12px;
      font-weight:800;
      text-transform:uppercase;
      letter-spacing:.6px;
      transition: .2s ease;
      display:inline-flex;
      align-items:center;
      gap:10px;
    }
    .btn-primary-cmd{
      background: linear-gradient(135deg, rgba(0,229,255,.92), rgba(42,255,122,.70));
      color:#051018;
      box-shadow: 0 12px 30px rgba(0,229,255,.10);
    }
    .btn-primary-cmd:hover{ transform: translateY(-1px); filter:brightness(1.05); }

    .btn-outline-cmd{
      background: rgba(255,255,255,.04);
      border:1px solid rgba(255,255,255,.14);
      color:#fff;
    }
    .btn-outline-cmd:hover{ transform: translateY(-1px); background: rgba(255,255,255,.07); }

    .panel{
      border:1px solid rgba(255,255,255,.10);
      background: rgba(0,0,0,.18);
      border-radius:16px;
      padding:16px;
      height:100%;
      position:relative;
      overflow:hidden;
    }

    .panel:before{
      content:"";
      position:absolute; inset:0;
      background: radial-gradient(700px 300px at 50% 0%, rgba(0,229,255,.14), transparent 55%);
      opacity:.6;
      pointer-events:none;
    }

    .panel h3{
      margin:0 0 10px;
      font-weight:800;
      text-transform:uppercase;
      letter-spacing:.8px;
      font-size:14px;
      color: rgba(255,255,255,.85);
    }

    .kpi{
      display:grid;
      grid-template-columns: 1fr 1fr;
      gap:10px;
      position:relative;
      z-index:1;
    }
    .kpi .box{
      border:1px solid rgba(255,255,255,.10);
      background: rgba(255,255,255,.04);
      border-radius:14px;
      padding:12px;
    }
    .kpi .label{
      font-size:11px;
      color: rgba(255,255,255,.65);
      text-transform:uppercase;
      letter-spacing:.7px;
    }
    .kpi .value{
      margin-top:6px;
      font-size:20px;
      font-weight:900;
      letter-spacing:.6px;
    }

    .list{
      margin-top:12px;
      position:relative;
      z-index:1;
    }
    .list .item{
      display:flex;
      gap:10px;
      padding:10px 10px;
      border-radius:12px;
      border:1px solid rgba(255,255,255,.08);
      background: rgba(255,255,255,.03);
      margin-bottom:10px;
    }
    .badge-ic{
      width:38px; height:38px;
      border-radius:12px;
      display:flex; align-items:center; justify-content:center;
      background: rgba(0,229,255,.10);
      border:1px solid rgba(0,229,255,.18);
    }
    .item strong{ display:block; font-size:13px; letter-spacing:.3px; }
    .item span{ display:block; font-size:12px; color: rgba(255,255,255,.70); margin-top:2px; }

    .footer{
      position:fixed;
      bottom:0;
      width:100%;
      text-align:center;
      padding:14px 10px;
      font-size:12px;
      color: rgba(255,255,255,.65);
      background: rgba(0,0,0,.25);
      border-top:1px solid rgba(255,255,255,.06);
      z-index:2;
    }

    /* subtle pulse on title line */
    .pulse{
      display:inline-block;
      border-bottom:1px dashed rgba(0,229,255,.35);
      padding-bottom:2px;
      animation: pulse 2.2s ease-in-out infinite;
    }
    @keyframes pulse{
      0%,100%{ filter: brightness(1); }
      50%{ filter: brightness(1.18); }
    }
  </style>
</head>

<body>
  <!-- Background layers -->
  <div class="layer grid" id="gridLayer"></div>
  <div class="layer sweep"></div>
  <div class="layer scanlines"></div>

  <div class="wrap">
    <div class="frame" id="frame">
      <div class="topbar">
        <div class="brand">
          <img src="assets/image/logo.jpg" alt="SecureHRMS">
          <div>
            <div class="name">SecureHRMS</div>
            <div class="tag">Command Operations • Workforce • Patrol • Incident</div>
          </div>
        </div>
        <div class="status-pills">
          <div class="pill"><span class="dot hud"></span> System: Online</div>
          <div class="pill"><span class="dot"></span> Attendance: Live</div>
          <div class="pill"><span class="dot gold"></span> Secure Channel</div>
        </div>
      </div>

      <div class="content">
        <div class="hero">
          <h1>Security <span class="pulse">Command</span><br>Operations Platform</h1>
          <p>
            Modern GuardPro-style HRMS for security agencies:
            roster control, GPS attendance, patrol verification, incident intelligence,
            and operational visibility — in one secure system.
          </p>

          <div class="cta">
            <a class="btn-cmd btn-primary-cmd" href="login.php">
              <i class="fas fa-sign-in-alt"></i> Access Console
            </a>
            <a class="btn-cmd btn-outline-cmd" href="register-admin.php">
              <i class="fas fa-user-shield"></i> Register Admin
            </a>
          </div>

          <div class="mt-4" style="color: rgba(255,255,255,.65); font-size:12px; letter-spacing:.4px;">
            <i class="fas fa-shield-alt" style="color: var(--hud);"></i>
            Hardened login • RBAC enforcement • Audit trail ready • PWA enabled
          </div>
        </div>

        <div class="panel">
          <h3>Operational Snapshot</h3>

          <div class="kpi">
            <div class="box">
              <div class="label"><i class="fas fa-user-clock"></i> Attendance</div>
              <div class="value">LIVE</div>
            </div>
            <div class="box">
              <div class="label"><i class="fas fa-route"></i> Patrol</div>
              <div class="value">QR + GPS</div>
            </div>
            <div class="box">
              <div class="label"><i class="fas fa-exclamation-triangle"></i> Incidents</div>
              <div class="value">Tracked</div>
            </div>
            <div class="box">
              <div class="label"><i class="fas fa-calendar-alt"></i> Roster</div>
              <div class="value">Weekly</div>
            </div>
          </div>

          <div class="list">
            <div class="item">
              <div class="badge-ic"><i class="fas fa-satellite-dish" style="color: var(--hud);"></i></div>
              <div>
                <strong>Real-time Monitoring</strong>
                <span>Supervisor dashboards for shifts, late alerts, patrol completion.</span>
              </div>
            </div>
            <div class="item">
              <div class="badge-ic"><i class="fas fa-camera" style="color: var(--hud2);"></i></div>
              <div>
                <strong>Verified Evidence</strong>
                <span>Photo proof for attendance, incidents, and patrol checkpoints.</span>
              </div>
            </div>
            <div class="item">
              <div class="badge-ic"><i class="fas fa-lock" style="color: var(--gold);"></i></div>
              <div>
                <strong>Access Control (RBAC)</strong>
                <span>Role-based modules: Admin/HR/Manager/Supervisor/Guard.</span>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>

  <div class="footer">
    © <?= date('Y') ?> SecureHRMS | Corporate Force Security Services Pte Ltd • Powered by CPForce Digital Systems
  </div>

  <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/jquery/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

  <script>
    // Beacons (floating "command" particles)
    (function(){
      const count = 48;
      for(let i=0;i<count;i++){
        const b = document.createElement('div');
        b.className='beacon';
        b.style.left = (Math.random()*100) + '%';
        b.style.top  = (60 + Math.random()*60) + 'vh';
        b.style.animationDuration = (5 + Math.random()*10) + 's';
        b.style.animationDelay = (Math.random()*3) + 's';
        b.style.opacity = (0.35 + Math.random()*0.55);
        b.style.transform = 'translateY(' + (Math.random()*80) + 'px)';
        document.body.appendChild(b);
      }
    })();

    // Parallax grid + subtle frame parallax (military HUD feel)
    (function(){
      const grid = document.getElementById('gridLayer');
      const frame = document.getElementById('frame');
      let px=0, py=0;

      window.addEventListener('mousemove', (e)=>{
        const cx = window.innerWidth/2;
        const cy = window.innerHeight/2;
        const dx = (e.clientX - cx) / cx;
        const dy = (e.clientY - cy) / cy;

        px = dx; py = dy;

        grid.style.transform = `translate3d(${dx*10}px, ${dy*10}px, 0)`;
        frame.style.transform = `translate3d(${dx*4}px, ${dy*3}px, 0)`;
      }, {passive:true});
    })();

    // PWA Service Worker
    if ('serviceWorker' in navigator) {
      navigator.serviceWorker.register('sw.js');
    }
  </script>
</body>
</html>