<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_role(['admin','hr']);

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    header('Location: index.php');
    exit;
}

$stmt = db()->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$user = $stmt->fetch();

if (!$user) {
    header('Location: index.php');
    exit;
}

$roles = db()->query("SELECT id, role_name FROM roles ORDER BY id")->fetchAll();

$currentRole = db()->prepare("SELECT role_id FROM user_roles WHERE user_id=?");
$currentRole->execute([$id]);
$currentRoleId = $currentRole->fetchColumn();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_validate($_POST['_csrf'] ?? null);

    $name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $status = $_POST['status'] ?? 'active';
    $roleId = (int)($_POST['role_id'] ?? 0);
    $removePhoto = isset($_POST['remove_photo']);

    if ($name === '' || $email === '' || $roleId <= 0) {
        $error = "All required fields must be filled.";
    } else {

        $photoPath = $user['photo_path'];

        // Remove photo
        if ($removePhoto && $photoPath) {
            $file = __DIR__ . '/../' . $photoPath;
            if (file_exists($file)) unlink($file);
            $photoPath = null;
        }

        // Replace photo
        if (!empty($_FILES['photo']['tmp_name'])) {

            $allowed = ['jpg','jpeg','png'];
            $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));

            if (!in_array($ext, $allowed, true)) {
                $error = "Invalid image format.";
            } else {

                $uploadDir = __DIR__ . '/../assets/uploads/profile/';
                if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

                $filename = 'user_' . time() . '_' . bin2hex(random_bytes(5)) . '.' . $ext;
                $destination = $uploadDir . $filename;

                if (move_uploaded_file($_FILES['photo']['tmp_name'], $destination)) {

                    // delete old photo
                    if ($user['photo_path']) {
                        $oldFile = __DIR__ . '/../' . $user['photo_path'];
                        if (file_exists($oldFile)) unlink($oldFile);
                    }

                    $photoPath = 'assets/uploads/profile/' . $filename;
                } else {
                    $error = "Upload failed.";
                }
            }
        }

        if ($error === '') {

            $stmt = db()->prepare("
                UPDATE users 
                SET full_name=?, email=?, status=?, photo_path=?
                WHERE id=?
            ");
            $stmt->execute([$name,$email,$status,$photoPath,$id]);

            db()->prepare("DELETE FROM user_roles WHERE user_id=?")->execute([$id]);
            db()->prepare("INSERT INTO user_roles(user_id, role_id) VALUES(?,?)")
               ->execute([$id,$roleId]);

            header("Location: index.php");
            exit;
        }
    }
}

include __DIR__ . '/../includes/header.php';
?>

<style>
.card-ultra {
    background: rgba(0,0,0,0.45);
    border: 1px solid rgba(0,229,255,0.15);
    border-radius: 18px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.6);
}

.form-control, .custom-select {
    background: rgba(255,255,255,0.05);
    border: 1px solid rgba(0,229,255,0.2);
    color: #fff;
}

.form-control:focus {
    border-color: #00e5ff;
    box-shadow: 0 0 10px rgba(0,229,255,0.5);
}

.profile-preview {
    width: 140px;
    height: 140px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid rgba(0,229,255,0.6);
    box-shadow: 0 0 25px rgba(0,229,255,0.6);
    margin-bottom: 15px;
}

.btn-ultra {
    background: linear-gradient(135deg,#00e5ff,#2aff7a);
    border: none;
    color: #000;
    font-weight: 600;
}
</style>

<div class="card card-ultra">
    <div class="card-header">
        <h3 class="card-title text-info">
            <i class="fas fa-user-edit"></i> Edit Operator Profile
        </h3>
    </div>

    <div class="card-body">

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

            <div class="row">
                <div class="col-md-4 text-center">

                    <?php
                    $photo = $user['photo_path'] ?: 'assets/img/default-avatar.png';
                    ?>

                    <img src="../<?= htmlspecialchars($photo) ?>"
                         id="photoPreview"
                         class="profile-preview">

                    <div class="form-group">
                        <label class="text-info">Replace Photo</label>
                        <input type="file"
                               name="photo"
                               class="form-control-file text-light"
                               accept="image/png,image/jpeg"
                               onchange="previewImage(event)">
                    </div>

                    <?php if ($user['photo_path']): ?>
                        <div class="form-check mt-2">
                            <input type="checkbox" name="remove_photo" class="form-check-input">
                            <label class="form-check-label text-danger">
                                Remove Current Photo
                            </label>
                        </div>
                    <?php endif; ?>

                </div>

                <div class="col-md-8">

                    <div class="form-group">
                        <label>Full Name</label>
                        <input name="full_name"
                               value="<?= htmlspecialchars($user['full_name']) ?>"
                               class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input name="email"
                               value="<?= htmlspecialchars($user['email']) ?>"
                               class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" class="custom-select">
                            <option value="active" <?= $user['status']=='active'?'selected':'' ?>>Active</option>
                            <option value="inactive" <?= $user['status']=='inactive'?'selected':'' ?>>Inactive</option>
                            <option value="suspended" <?= $user['status']=='suspended'?'selected':'' ?>>Suspended</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Role</label>
                        <select name="role_id" class="custom-select" required>
                            <?php foreach($roles as $r): ?>
                                <option value="<?= (int)$r['id'] ?>"
                                    <?= $currentRoleId==$r['id']?'selected':'' ?>>
                                    <?= htmlspecialchars($r['role_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <button class="btn btn-ultra">
                        <i class="fas fa-save"></i> Update Operator
                    </button>

                    <a href="index.php" class="btn btn-outline-light ml-2">
                        Cancel
                    </a>

                </div>
            </div>
        </form>
    </div>
</div>

<script>
function previewImage(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('photoPreview').src = reader.result;
    };
    reader.readAsDataURL(event.target.files[0]);
}
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>