<?php
require_once '../includes/config.php';

if (isset($_POST['add_user'])) {
  $username = $_POST['username'];
  $email = $_POST['email'];
  $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
  $contact = $_POST['contact'] ?? '';
  $role = $_POST['role'];
  $status = $_POST['status'];
  $officer_status = $_POST['officer_status'];
  $profile_image = '';

  // Handle image upload if present
  if (!empty($_FILES['profile_image']['name'])) {
    $targetDir = "../uploads/users/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
    $filename = basename($_FILES['profile_image']['name']);
    $ext = pathinfo($filename, PATHINFO_EXTENSION);
    $newFilename = 'user_' . time() . '.' . $ext;
    $targetFile = $targetDir . $newFilename;
    move_uploaded_file($_FILES['profile_image']['tmp_name'], $targetFile);
    $profile_image = $newFilename;
  }

  // Insert user
  $stmt = $pdo->prepare("INSERT INTO users (username, email, password, contact, role, status, officer_status, profile_image) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
  $stmt->execute([$username, $email, $password, $contact, $role, $status, $officer_status, $profile_image]);

  header("Location: manage_users.php?added=1");
  exit;
}
?>

