<?php
require_once '../includes/config.php';

// Latest Incidents (no JOIN)
$incidents = $pdo->query("
  SELECT id, title, status, created_at 
  FROM incident_reports
  ORDER BY created_at DESC
  LIMIT 5
")->fetchAll();

// On-Duty Officers
$onDuty = $pdo->query("
  SELECT a.*, u.username, s.site_name 
  FROM attendance a
  LEFT JOIN users u ON a.user_id = u.id
  LEFT JOIN sites s ON u.site_id = s.id
  WHERE a.date = CURDATE()
  ORDER BY a.time_in DESC
  LIMIT 5
")->fetchAll();

// Site & Officer Count
$siteCount = $pdo->query("SELECT COUNT(*) FROM sites")->fetchColumn();
$officerCount = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'officer'")->fetchColumn();
?>

<!-- KPI Cards -->
<div class="col-md-3">
  <div class="small-box bg-info">
    <div class="inner">
      <h3><?= $siteCount ?></h3>
      <p>Client Sites</p>
    </div>
    <div class="icon"><i class="fas fa-map-marker-alt"></i></div>
  </div>
</div>

<div class="col-md-3">
  <div class="small-box bg-success">
    <div class="inner">
      <h3><?= count($onDuty) ?></h3>
      <p>On-Duty Officers</p>
    </div>
    <div class="icon"><i class="fas fa-user-shield"></i></div>
  </div>
</div>

<!-- Live Incident Alerts -->
<div class="col-md-6">
  <div class="card border-danger">
    <div class="card-header bg-danger text-white">🚨 Latest Incident Alerts</div>
    <ul class="list-group list-group-flush">
      <?php if (count($incidents) === 0): ?>
        <li class="list-group-item text-muted">No incidents reported.</li>
      <?php else: ?>
        <?php foreach ($incidents as $i): ?>
          <li class="list-group-item d-flex justify-content-between align-items-center <?= $i['status'] === 'pending' ? 'live-alert' : '' ?>">
            <div>
              <strong><?= htmlspecialchars($i['title']) ?></strong><br>
              <small><?= date("d M H:i", strtotime($i['created_at'])) ?></small>
            </div>
            <span class="badge bg-<?= $i['status'] === 'pending' ? 'warning' : ($i['status'] === 'resolved' ? 'success' : 'secondary') ?>">
              <?= ucfirst($i['status']) ?>
            </span>
          </li>
        <?php endforeach; ?>
      <?php endif; ?>
    </ul>
  </div>
</div>

<!-- Latest On-Duty Officer Log -->
<div class="col-md-12 mt-3">
  <div class="card">
    <div class="card-header bg-primary text-white">👮 Recently Clocked-In Officers</div>
    <div class="table-responsive">
      <table class="table table-sm table-hover mb-0">
        <thead class="table-light">
          <tr>
            <th>Officer</th>
            <th>Time In</th>
            <th>Site</th>
            <th>Time Out</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($onDuty as $o): ?>
            <tr>
              <td><?= htmlspecialchars($o['username']) ?></td>
              <td><?= htmlspecialchars($o['time_in']) ?></td>
              <td><?= htmlspecialchars($o['site_name'] ?? 'Unassigned') ?></td>
              <td><?= $o['time_out'] ? htmlspecialchars($o['time_out']) : '<span class="text-warning">Still On Duty</span>' ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
