<?php
require_once '../includes/config.php';

$filter = $_GET['filter'] ?? 'today';

$where = "1";
$params = [];

switch ($filter) {
    case 'today':
        $where = "DATE(created_at) = CURDATE()";
        break;
    case '7days':
        $where = "created_at >= CURDATE() - INTERVAL 7 DAY";
        break;
    case 'all':
    default:
        $where = "1";
        break;
}

try {
    $stmt = $pdo->prepare("SELECT title, status, created_at FROM incident_reports WHERE $where ORDER BY created_at DESC LIMIT 10");
    $stmt->execute($params);
    $incidents = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($incidents) {
        foreach ($incidents as $incident) {
            $statusColor = match($incident['status']) {
                'approved' => 'success',
                'rejected' => 'danger',
                'pending' => 'secondary',
                default => 'secondary',
            };

            echo '<li class="list-group-item">';
            echo '<strong>' . htmlspecialchars($incident['title']) . '</strong> ';
            echo '<span class="badge bg-' . $statusColor . ' text-uppercase float-end">' . ucfirst($incident['status']) . '</span><br>';
            echo '<small class="text-muted">Reported on: ' . date('d M Y H:i', strtotime($incident['created_at'])) . '</small>';
            echo '</li>';
        }
    } else {
        echo '<li class="list-group-item text-muted">No incidents found for this filter.</li>';
    }
} catch (Exception $e) {
    echo '<li class="list-group-item text-danger">Error: ' . htmlspecialchars($e->getMessage()) . '</li>';
}
