<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $incidentId = intval($_POST['incident_id'] ?? 0);
    $action = $_POST['action'] ?? '';

    if (!in_array($action, ['approve', 'reject'])) {
        $_SESSION['toast'] = [
            'type' => 'danger',
            'message' => 'Invalid action.'
        ];
        header("Location: command_center.php");
        exit;
    }

    // Update incident status
    $stmt = $pdo->prepare("UPDATE incident_reports SET status = :status, updated_at = NOW() WHERE id = :id");
    $stmt->execute([
        ':status' => $action,
        ':id' => $incidentId
    ]);

    $_SESSION['toast'] = [
        'type' => 'success',
        'message' => "Incident #$incidentId has been " . ucfirst($action) . "d successfully."
    ];
}

header("Location: command_center.php");
exit;
