<?php
require_once '../includes/config.php'; // adjust the path as needed

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['title'], $data['latitude'], $data['longitude'])) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid input"]);
    exit;
}

$title = trim($data['title']);
$lat = floatval($data['latitude']);
$lng = floatval($data['longitude']);

try {
    $stmt = $pdo->prepare("INSERT INTO gps_locations (title, latitude, longitude) VALUES (?, ?, ?)");
    $stmt->execute([$title, $lat, $lng]);

    echo json_encode(["success" => true, "message" => "Location saved successfully"]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
