<?php
session_start();
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  echo json_encode(['success' => false]);
  exit;
}

$id = intval($_POST['id'] ?? 0);
$completed = intval($_POST['completed'] ?? 0);
$adminId = $_SESSION['user_id'];

$update = $pdo->prepare("UPDATE dashboard_tasks SET completed = ? WHERE id = ? AND admin_id = ?");
if ($update->execute([$completed, $id, $adminId])) {
  echo json_encode(['success' => true]);
} else {
  echo json_encode(['success' => false]);
}
