<?php
session_start();
require_once '../includes/config.php';

$stmt = $pdo->query("
  SELECT ol.*, o.name AS officer_name, s.site_name 
  FROM occurrence_log ol
  JOIN officers o ON ol.officer_id = o.id
  JOIN sites s ON ol.site_id = s.id
  ORDER BY ol.logged_at DESC
");
$logs = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>View OB Log</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>

<?php include '../includes/navbar.php'; ?>
<div class="container-fluid mt-4">
  <div class="row">
    <div class="col-md-2">
      <?php include '../includes/sidebar_admin.php'; ?>
    </div>
    <div class="col-md-10">
      <h4>📒 Occurrence Book Log</h4>
      <table class="table table-bordered table-hover mt-3">
        <thead class="table-dark">
          <tr>
            <th>Date & Time</th>
            <th>Officer</th>
            <th>Site</th>
            <th>Category</th>
            <th>Description</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($logs as $log): ?>
            <tr>
              <td><?= $log['logged_at'] ?></td>
              <td><?= htmlspecialchars($log['officer_name']) ?></td>
              <td><?= htmlspecialchars($log['site_name']) ?></td>
              <td><?= $log['category'] ?></td>
              <td><?= htmlspecialchars($log['description']) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</body>
</html>
