<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
  header("Location: ../auth/login.php");
  exit;
}

$controller_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Controller';

// Fetch all controller attendance
$stmt = $pdo->prepare("
    SELECT ca.*, u.username 
    FROM controller_attendance ca
    JOIN users u ON ca.controller_id = u.id
    WHERE ca.controller_id = ?
    ORDER BY ca.date DESC
");
$stmt->execute([$controller_id]);
$records = $stmt->fetchAll();

function getShift($timeIn) {
  if (!$timeIn) return '-';
  $hour = (int)date('H', strtotime($timeIn));
  return ($hour >= 8 && $hour < 20) ? 'A Shift (08 AM - 08 PM)' : 'B Shift (08 PM - 08 AM)';
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>My Attendance</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/controller_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar_controller.php'; ?>

<div class="main-content" id="mainContent">
            <div class="container mt-4">
            <h4 class="mb-3">🕒 <?= htmlspecialchars($username) ?> - Attendance Records</h4>

            <table class="table table-bordered table-striped small">
                <thead class="table-dark">
                <tr>
                <th>#</th>
                    <th>Controller</th>
                    <th>Date</th>
                    <th>Time In</th>
                    <th>Time Out</th>
                    <th>Shift</th>
                </tr>
                </thead>
                    <tbody>
                    <?php foreach ($records as $i => $r): ?>
                    <tr>
                    <td><?= $i + 1 ?></td>
                        <td><?= htmlspecialchars($r['username']) ?></td>
                        <td><?= date('d M Y', strtotime($r['date'])) ?></td>
                        <td><?= $r['time_in'] ? date('H:i', strtotime($r['time_in'])) : '<span class="text-muted">-</span>' ?></td>
                        <td><?= $r['time_out'] ? date('H:i', strtotime($r['time_out'])) : '<span class="text-muted">-</span>' ?></td>
                        <td><?= getShift($r['time_in']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($records)): ?>
                    <tr><td colspan="5" class="text-center text-muted">No attendance records found.</td></tr>
                    <?php endif; ?>
                    </tbody>
            </table>
            </div>
    </div>
</body>
</html>
