<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'controller') {
    header("Location: ../auth/login.php");
    exit;
}

$today = date('Y-m-d');
$weekAgo = date('Y-m-d', strtotime('-6 days'));

// Fetch attendance records for the past 7 days
$stmt = $pdo->prepare("
    SELECT a.*, u.username, s.site_name
    FROM attendance a
    JOIN users u ON a.officer_id = u.id
    LEFT JOIN sites s ON u.site_id = s.id
    WHERE a.date BETWEEN ? AND ?
    ORDER BY a.date DESC, u.username
");
$stmt->execute([$weekAgo, $today]);
$records = $stmt->fetchAll(PDO::FETCH_GROUP | PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Weekly Officer Attendance</title>
    <link rel="stylesheet" href="../assets/css/controller_dashboard.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar_controller.php'; ?>

<div class="main-content" id="mainContent">
    <div class="container mt-4">

        <h4>📅 Officer Attendance: <?= date('d M Y', strtotime($weekAgo)) ?> – <?= date('d M Y', strtotime($today)) ?></h4>
        <hr>

        <?php if (!empty($records)): ?>
            <?php foreach ($records as $date => $entries): ?>
                <div class="table-responsive">
                    <table id="siteTable" class="table table-bordered table-striped small">
                        <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Officer</th>
                                    <th>Site</th>
                                    <th>Time In</th>
                                    <th>Time Out</th>
                                    <th>Status</th>
                                </tr>
                        </thead>
                        <tbody>
                                <?php foreach ($entries as $i => $r): ?>
                                    <tr>
                                        <td><?= $i + 1 ?></td>
                                        <td><?= htmlspecialchars($r['username']) ?></td>
                                        <td><?= htmlspecialchars($r['site_name'] ?? 'Unassigned') ?></td>
                                        <td><?= $r['time_in'] ? date('h:i A', strtotime($r['time_in'])) : '-' ?></td>
                                        <td><?= $r['time_out'] ? date('h:i A', strtotime($r['time_out'])) : '<span class="text-danger">Not Signed Out</span>' ?></td>
                                        <td>
                                            <?php if ($r['time_in'] && $r['time_out']): ?>
                                                <span class="badge bg-success">✔ Completed</span>
                                            <?php elseif ($r['time_in']): ?>
                                                <span class="badge bg-warning text-dark">⏳ Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">-</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                </div>
                <?php endforeach; ?>
            
            <?php else: ?>
                <div class="alert alert-info">No attendance records found for the past week.</div>
            <?php endif; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
