<?php
session_start();
require_once '../includes/config.php';

// 🚫 Block if not logged in
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
    header("Location: ../auth/login.php");
    exit;
}

$success = $error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ✅ Safe fallback: use 0 if session is missing
    $userId = $_SESSION['user_id'] ?? 0;
    $officerId = $userId;
    $location = $_POST['location'] ?? '';
    $description = $_POST['description'] ?? '';
    $incidentDate = date('Y-m-d');
    $incidentTime = date('H:i:s');

    // 🖼️ Upload photo (optional, single)
    $photoPath = '';
    if (!empty($_FILES['photo']['name'])) {
        $uploadDir = '../uploads/incidents/photos/';
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $filename = time() . '_' . basename($_FILES['photo']['name']);
        $targetPath = $uploadDir . $filename;

        if (move_uploaded_file($_FILES['photo']['tmp_name'], $targetPath)) {
            $photoPath = $filename;
        } else {
            $error = "❌ Failed to upload photo.";
        }
    }

    // 🆔 Generate unique report_number
    $prefix = "REP" . date("Ymd");
    $stmt = $pdo->prepare("SELECT COUNT(*) AS count FROM incident_reports WHERE report_number LIKE ?");
    $stmt->execute([$prefix . '%']);
    $next = $stmt->fetch()['count'] + 1;
    $reportNumber = $prefix . str_pad($next, 4, '0', STR_PAD_LEFT);

    if (empty($error)) {
        try {
            $stmt = $pdo->prepare("
                INSERT INTO incident_reports (
                    user_id, officer_id, controller_id, submitted_by_role,
                    site_id, title, description, incident_date, incident_time,
                    photo, video, report_number, status,
                    informant_name, contact_no, recording_officer, reported_at, location
                ) VALUES (
                    :user_id, :officer_id, :controller_id, :submitted_by_role,
                    :site_id, :title, :description, :incident_date, :incident_time,
                    :photo, :video, :report_number, :status,
                    :informant_name, :contact_no, :recording_officer, NOW(), :location
                )
            ");

            $stmt->execute([
                ':user_id' => $userId, // ✅ CRITICAL: must be bound
                ':officer_id' => $officerId,
                ':controller_id' => null,
                ':submitted_by_role' => 'officer',
                ':site_id' => 0,
                ':title' => 'Incident Report',
                ':description' => $description,
                ':incident_date' => $incidentDate,
                ':incident_time' => $incidentTime,
                ':photo' => $photoPath,
                ':video' => null,
                ':report_number' => $reportNumber,
                ':status' => 'pending',
                ':informant_name' => '',
                ':contact_no' => '',
                ':recording_officer' => '',
                ':location' => $location
            ]);

            $success = "✅ Incident reported successfully.";
        } catch (PDOException $e) {
            $error = "❌ DB error: " . $e->getMessage();
        }
    }
}
?>
