<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}

$officer_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? 'Officer';

// Fetch roster
$stmt = $pdo->prepare("
  SELECT r.shift_date, r.shift_type, s.site_name 
  FROM officer_roster r 
  JOIN sites s ON r.site_id = s.id 
  WHERE r.officer_id = ? 
  ORDER BY r.shift_date DESC
");
$stmt->execute([$officer_id]);
$rosters = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>My Roster Schedule</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css" rel="stylesheet">
  <style>
    body { background-color: #f5f9fc; font-family: 'Segoe UI', sans-serif; }
    .container { max-width: 1000px; }
  </style>
</head>
<body>

<div class="container py-4">
  <h4 class="mb-4 text-primary">📋 My Roster Schedule</h4>

  <div class="row mb-3">
    <div class="col-md-3">
      <input type="date" id="fromDate" class="form-control" placeholder="From">
    </div>
    <div class="col-md-3">
      <input type="date" id="toDate" class="form-control" placeholder="To">
    </div>
    <div class="col-md-6 text-end">
      <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a>
    </div>
  </div>

  <div class="table-responsive">
    <table id="rosterTable" class="table table-bordered table-striped small">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Date</th>
          <th>Shift</th>
          <th>Site</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rosters as $i => $r): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= $r['shift_date'] ?></td>
          <td><?= $r['shift_type'] === 'A' ? 'Day (08AM–08PM)' : 'Night (08PM–08AM)' ?></td>
          <td><?= htmlspecialchars($r['site_name']) ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($rosters)): ?>
          <tr><td colspan="4" class="text-center text-muted">No roster assigned.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
$(document).ready(function () {
  const table = $('#rosterTable').DataTable({
    dom: 'Bfrtip',
    buttons: ['excelHtml5', 'print'],
    order: [[1, 'desc']]
  });

  $('#fromDate, #toDate').on('change', function () {
    const from = $('#fromDate').val();
    const to = $('#toDate').val();

    $.fn.dataTable.ext.search.push(function (settings, data) {
      const date = data[1]; // shift_date column
      if (!from && !to) return true;
      if (from && date < from) return false;
      if (to && date > to) return false;
      return true;
    });

    table.draw();
    $.fn.dataTable.ext.search.pop();
  });
});
</script>

</body>
</html>
