<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Command Center Monitoring | CFS System OS</title>
  <meta charset="UTF-8">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
  <style>
    .card { border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
    .live-alert { animation: flash 1s infinite alternate; }
    @keyframes flash { from { background-color: #fff3cd; } to { background-color: #f8d7da; } }
  </style>
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content p-4" id="dashboard-area">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>📡 Command Center Monitoring</h4>
    <div>
      <button id="exportPNG" class="btn btn-outline-primary btn-sm">📸 Export PNG</button>
      <button id="exportPDF" class="btn btn-outline-danger btn-sm">📄 Export PDF</button>
    </div>
  </div>

  <div class="row g-4" id="dashboard-content">
    <!-- AJAX data loads here -->
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Refresh content via AJAX every 10 seconds
function loadDashboard() {
  $.get("ajax_dashboard_data.php", function(html) {
    $("#dashboard-content").html(html);
  });
}

loadDashboard();
setInterval(loadDashboard, 10000); // refresh every 10s

// Export to PNG
$("#exportPNG").on("click", function () {
  html2canvas(document.querySelector("#dashboard-area")).then(canvas => {
    var link = document.createElement('a');
    link.download = 'command_center.png';
    link.href = canvas.toDataURL("image/png");
    link.click();
  });
});

// Export to PDF
$("#exportPDF").on("click", function () {
  html2canvas(document.querySelector("#dashboard-area")).then(canvas => {
    const { jsPDF } = window.jspdf;
    const pdf = new jsPDF();
    const img = canvas.toDataURL("image/png");
    pdf.addImage(img, 'PNG', 10, 10, 190, 0);
    pdf.save("command_center.pdf");
  });
});
</script>

<script>
  const ctx = document.getElementById('trendChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: <?= $trendLabels ?>,
      datasets: [{
        label: 'Check-ins',
        data: <?= $trendCounts ?>,
        backgroundColor: '#004080',
        borderRadius: 8
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 1 }
        }
      }
    }
  });
</script>

</body>
</html>
