<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$attendances = $pdo->query("
    SELECT a.*, u.username 
    FROM attendance a 
    JOIN users u ON a.officer_id = u.id 
    WHERE a.time_out IS NULL 
    ORDER BY a.date DESC
")->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Edit Attendance</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">

<div class="container mt-4">
  <h4>🕒 Edit Attendance - Missing Sign Out</h4>
  <div class="table-responsive mt-3">
    <table class="table table-bordered table-striped align-middle small">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Officer</th>
          <th>Date</th>
          <th>Time In</th>
          <th>Time Out</th>
          <th>Set Time Out</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($attendances as $i => $row): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($row['username']) ?></td>
          <td><?= $row['date'] ?></td>
          <td><?= $row['time_in'] ?></td>
          <td><?= $row['time_out'] ?: '<span class="text-danger">Missing</span>' ?></td>
          <td>
            <form method="post" action="update_attendance.php" class="d-flex gap-2">
              <input type="hidden" name="id" value="<?= $row['id'] ?>">
              <input type="datetime-local" name="time_out" required class="form-control form-control-sm">
              <button class="btn btn-success btn-sm">Update</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($attendances)): ?>
        <tr><td colspan="6" class="text-center text-muted">No missing sign-outs found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
</div>
</body>
</html>
