<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;
$year = date('Y');

if ($action === 'add') {
  $officer_id = $_POST['officer_id'];
  $annual = (int) $_POST['annual_leave'];
  $medical = (int) $_POST['medical_leave'];
  $hospital = (int) $_POST['hospital_leave'];
  $unpaid = (int) $_POST['unpaid_leave'];

  $stmt = $pdo->prepare("INSERT INTO leave_balance (officer_id, year, annual_leave, medical_leave, hospital_leave, unpaid_leave) VALUES (?, ?, ?, ?, ?, ?)");
  $stmt->execute([$officer_id, $year, $annual, $medical, $hospital, $unpaid]);

} elseif ($action === 'update' && $id) {
  $annual = (int) $_POST['annual_leave'];
  $medical = (int) $_POST['medical_leave'];
  $hospital = (int) $_POST['hospital_leave'];
  $unpaid = (int) $_POST['unpaid_leave'];

  $stmt = $pdo->prepare("UPDATE leave_balance SET annual_leave=?, medical_leave=?, hospital_leave=?, unpaid_leave=? WHERE id=?");
  $stmt->execute([$annual, $medical, $hospital, $unpaid, $id]);

} elseif ($action === 'delete' && $id) {
  $stmt = $pdo->prepare("DELETE FROM leave_balance WHERE id = ?");
  $stmt->execute([$id]);
}

header("Location: manage_leave.php");
exit;
