<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$year = date('Y');

// Fetch leave balances
$stmt = $pdo->prepare("
  SELECT l.*, u.username FROM leave_balance l
  JOIN users u ON l.officer_id = u.id
  WHERE l.year = ?
  ORDER BY u.username
");
$stmt->execute([$year]);
$leaveList = $stmt->fetchAll();

// Fetch officer list
$officers = $pdo->query("SELECT id, username FROM users WHERE role = 'officer' ORDER BY username ASC")->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Manage Leave Entitlements</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content" id="mainContent">

      <div class="container mt-4">
        <h4 class="text-white">📋 Manage Leave Entitlements - <?= $year ?></h4>
        <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addLeaveModal">➕ Add Leave</button>

        <table class="table table-bordered table-striped align-middle">
          <thead class="table-dark">
            <tr>
              <th>#</th>
              <th>Officer</th>
              <th>Total Leave</th>
              <th>Used Leave</th>
              <th>Remaining</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($leaveList as $i => $leave): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= htmlspecialchars($leave['username']) ?></td>
              <td><?= $leave['total_leave'] ?></td>
              <td><?= $leave['used_leave'] ?></td>
              <td><?= $leave['total_leave'] - $leave['used_leave'] ?></td>
              <td>
                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?= $leave['id'] ?>">✏️ Edit</button>
                <form method="post" action="manage_leave_action.php" class="d-inline" onsubmit="return confirm('Delete this record?');">
                  <input type="hidden" name="action" value="delete">
                  <input type="hidden" name="id" value="<?= $leave['id'] ?>">
                  <button class="btn btn-danger btn-sm">🗑</button>
                </form>
              </td>
            </tr>

            <!-- Edit Modal -->
            <div class="modal fade" id="edit<?= $leave['id'] ?>" tabindex="-1">
              <div class="modal-dialog">
                <form method="post" action="manage_leave_action.php" class="modal-content">
                  <input type="hidden" name="action" value="update">
                  <input type="hidden" name="id" value="<?= $leave['id'] ?>">
                  <div class="modal-header">
                    <h5 class="modal-title">Edit Leave</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                  </div>
                  <div class="modal-body">
                    <input name="total_leave" class="form-control" type="number" value="<?= $leave['total_leave'] ?>" required>
                    <label class="form-text">Total Leave for <?= $leave['year'] ?></label>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-success">Update</button>
                  </div>
                </form>
              </div>
            </div>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <!-- Add Modal -->
      <div class="modal fade" id="addLeaveModal" tabindex="-1">
        <div class="modal-dialog">
          <form method="post" action="manage_leave_action.php" class="modal-content">
            <input type="hidden" name="action" value="add">
            <div class="modal-header">
              <h5 class="modal-title">Add Officer Leave</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
              <select name="officer_id" class="form-select mb-2" required>
                <option value="">-- Select Officer --</option>
                <?php foreach ($officers as $officer): ?>
                <option value="<?= $officer['id'] ?>"><?= htmlspecialchars($officer['username']) ?></option>
                <?php endforeach; ?>
              </select>
              <input name="total_leave" class="form-control" type="number" placeholder="Total Leave Days" required>
            </div>
            <div class="modal-footer">
              <button class="btn btn-primary">Add</button>
            </div>
          </form>
        </div>
      </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
