<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

// Handle upload
$success = $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $officer_id = $_POST['officer_id'];
  $month = $_POST['month'];

  if ($_FILES['payslip']['error'] === 0 && $_FILES['payslip']['type'] === 'application/pdf') {
    $filename = time() . "_" . basename($_FILES['payslip']['name']);
    $targetPath = "../uploads/payslips/" . $filename;

    if (move_uploaded_file($_FILES['payslip']['tmp_name'], $targetPath)) {
      $stmt = $pdo->prepare("INSERT INTO payslips (officer_id, month, file_path) VALUES (?, ?, ?)");
      $stmt->execute([$officer_id, $month, $filename]);
      $success = "Payslip uploaded successfully.";
    } else {
      $error = "Failed to move uploaded file.";
    }
  } else {
    $error = "Only PDF files are allowed.";
  }
}

// Fetch officers
$officers = $pdo->query("SELECT id, username FROM users WHERE role = 'officer' ORDER BY username ASC")->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Upload Payslips | CFS System OS</title>
  <meta charset="UTF-8">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content p-4" style="max-width:600px;">
  <h4>📤 Upload Payslip (PDF)</h4>

  <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
  <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

  <form method="post" enctype="multipart/form-data">
    <div class="mb-3">
      <label>Officer</label>
      <select name="officer_id" class="form-control" required>
        <option value="">Select officer</option>
        <?php foreach ($officers as $o): ?>
        <option value="<?= $o['id'] ?>"><?= htmlspecialchars($o['username']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="mb-3">
      <label>Month</label>
      <input type="text" name="month" class="form-control" placeholder="e.g. March 2025" required>
    </div>

    <div class="mb-3">
      <label>Payslip PDF</label>
      <input type="file" name="payslip" accept="application/pdf" class="form-control" required>
    </div>

    <button class="btn btn-primary">Upload</button>
    <a href="view_payslips.php" class="btn btn-secondary">View Payslips</a>
  </form>
</div>

<script>
  const ctx = document.getElementById('trendChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: <?= $trendLabels ?>,
      datasets: [{
        label: 'Check-ins',
        data: <?= $trendCounts ?>,
        backgroundColor: '#004080',
        borderRadius: 8
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 1 }
        }
      }
    }
  });
</script>

</body>
</html>
