<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
  header("Location: ../auth/login.php");
  exit;
}

$dateFilter = $_GET['date'] ?? '';

// Fetch attendance with optional date filter
$query = "
  SELECT a.*, u.username 
  FROM attendance a 
  JOIN users u ON a.officer_id = u.id
";

if (!empty($dateFilter)) {
  $query .= " WHERE a.date = ?";
  $stmt = $pdo->prepare($query);
  $stmt->execute([$dateFilter]);
} else {
  $query .= " ORDER BY a.date DESC, a.time_in DESC";
  $stmt = $pdo->query($query);
}

$records = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
  <title>View Attendance | CFS System OS</title>
  <meta charset="UTF-8">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/css/admin_dashboard.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

<?php include '../includes/topbar.php'; ?>
<?php include '../includes/sidebar.php'; ?>

<div class="main-content p-4">
  <h4>🕒 Attendance Records</h4>

  <form class="row g-3 mb-3" method="get">
    <div class="col-auto">
      <input type="date" name="date" value="<?= htmlspecialchars($dateFilter) ?>" class="form-control">
    </div>
    <div class="col-auto">
      <button class="btn btn-primary">Filter by Date</button>
      <a href="view_attendance.php" class="btn btn-secondary">Clear</a>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-hover align-middle">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Officer</th>
          <th>Date</th>
          <th>Time In</th>
          <th>GPS In</th>
          <th>Time Out</th>
          <th>GPS Out</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($records as $i => $row): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><?= htmlspecialchars($row['username']) ?></td>
          <td><?= $row['date'] ?></td>
          <td><?= $row['time_in'] ?? '<span class="text-muted">-</span>' ?></td>
          <td><?= $row['gps_in'] ?? '<span class="text-muted">-</span>' ?></td>
          <td><?= $row['time_out'] ?? '<span class="text-muted">-</span>' ?></td>
          <td><?= $row['gps_out'] ?? '<span class="text-muted">-</span>' ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (empty($records)): ?>
        <tr><td colspan="7" class="text-center text-muted">No records found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
  const ctx = document.getElementById('trendChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: <?= $trendLabels ?>,
      datasets: [{
        label: 'Check-ins',
        data: <?= $trendCounts ?>,
        backgroundColor: '#004080',
        borderRadius: 8
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 1 }
        }
      }
    }
  });
</script>

</body>
</html>
