<?php
session_start();
require_once '../includes/config.php';

$stmt = $pdo->query("
  SELECT i.*, o.name AS officer_name, s.site_name 
  FROM incidents i
  JOIN officers o ON i.officer_id = o.id
  JOIN sites s ON i.site_id = s.id
  ORDER BY i.reported_at DESC
");
$incidents = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>View Incidents</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>

<?php include '../includes/navbar.php'; ?>
<div class="container-fluid mt-4">
  <div class="row">
    <div class="col-md-2">
      <?php include '../includes/sidebar_admin.php'; ?>
    </div>
    <div class="col-md-10">
      <h4>🚨 Incident Reports</h4>
      <table class="table table-bordered table-hover mt-3">
        <thead class="table-dark">
          <tr>
            <th>Title</th>
            <th>Officer</th>
            <th>Site</th>
            <th>Status</th>
            <th>Media</th>
            <th>Reported At</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($incidents as $inc): ?>
            <tr>
              <td><?= htmlspecialchars($inc['title']) ?></td>
              <td><?= htmlspecialchars($inc['officer_name']) ?></td>
              <td><?= htmlspecialchars($inc['site_name']) ?></td>
              <td><?= strtoupper($inc['status']) ?></td>
              <td>
                <?php if ($inc['photo']): ?>
                  <a href="../<?= $inc['photo'] ?>" target="_blank">📷</a>
                <?php endif; ?>
                <?php if ($inc['video']): ?>
                  <a href="../<?= $inc['video'] ?>" target="_blank">🎥</a>
                <?php endif; ?>
              </td>
              <td><?= $inc['reported_at'] ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

</body>
</html>
